/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEdgeDeploymentPlanResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEdgeDeploymentPlanResponse> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanArn").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPlanArn)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::edgeDeploymentPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build()}).build();
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanName").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPlanName)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::edgeDeploymentPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build()}).build();
    private static final SdkField<List<EdgeDeploymentModelConfig>> MODEL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelConfigs").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::modelConfigs)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::modelConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeDeploymentModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::deviceFleetName)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentSuccess").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentSuccess)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::edgeDeploymentSuccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentSuccess").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentPending").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentPending)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::edgeDeploymentPending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPending").build()}).build();
    private static final SdkField<Integer> EDGE_DEPLOYMENT_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EdgeDeploymentFailed").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::edgeDeploymentFailed)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::edgeDeploymentFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentFailed").build()}).build();
    private static final SdkField<List<DeploymentStageStatusSummary>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stages").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::stages)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentStageStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::nextToken)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::creationTime)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeEdgeDeploymentPlanResponse.getter(DescribeEdgeDeploymentPlanResponse::lastModifiedTime)).setter(DescribeEdgeDeploymentPlanResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_DEPLOYMENT_PLAN_ARN_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, MODEL_CONFIGS_FIELD, DEVICE_FLEET_NAME_FIELD, EDGE_DEPLOYMENT_SUCCESS_FIELD, EDGE_DEPLOYMENT_PENDING_FIELD, EDGE_DEPLOYMENT_FAILED_FIELD, STAGES_FIELD, NEXT_TOKEN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEdgeDeploymentPlanResponse.memberNameToFieldInitializer();
    private final String edgeDeploymentPlanArn;
    private final String edgeDeploymentPlanName;
    private final List<EdgeDeploymentModelConfig> modelConfigs;
    private final String deviceFleetName;
    private final Integer edgeDeploymentSuccess;
    private final Integer edgeDeploymentPending;
    private final Integer edgeDeploymentFailed;
    private final List<DeploymentStageStatusSummary> stages;
    private final String nextToken;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private DescribeEdgeDeploymentPlanResponse(BuilderImpl builder) {
        super(builder);
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.modelConfigs = builder.modelConfigs;
        this.deviceFleetName = builder.deviceFleetName;
        this.edgeDeploymentSuccess = builder.edgeDeploymentSuccess;
        this.edgeDeploymentPending = builder.edgeDeploymentPending;
        this.edgeDeploymentFailed = builder.edgeDeploymentFailed;
        this.stages = builder.stages;
        this.nextToken = builder.nextToken;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String edgeDeploymentPlanArn() {
        return this.edgeDeploymentPlanArn;
    }

    public final String edgeDeploymentPlanName() {
        return this.edgeDeploymentPlanName;
    }

    public final boolean hasModelConfigs() {
        return this.modelConfigs != null && !(this.modelConfigs instanceof SdkAutoConstructList);
    }

    public final List<EdgeDeploymentModelConfig> modelConfigs() {
        return this.modelConfigs;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final Integer edgeDeploymentSuccess() {
        return this.edgeDeploymentSuccess;
    }

    public final Integer edgeDeploymentPending() {
        return this.edgeDeploymentPending;
    }

    public final Integer edgeDeploymentFailed() {
        return this.edgeDeploymentFailed;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<DeploymentStageStatusSummary> stages() {
        return this.stages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelConfigs() ? this.modelConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPending());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEdgeDeploymentPlanResponse)) {
            return false;
        }
        DescribeEdgeDeploymentPlanResponse other = (DescribeEdgeDeploymentPlanResponse)((Object)obj);
        return Objects.equals(this.edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn()) && Objects.equals(this.edgeDeploymentPlanName(), other.edgeDeploymentPlanName()) && this.hasModelConfigs() == other.hasModelConfigs() && Objects.equals(this.modelConfigs(), other.modelConfigs()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.edgeDeploymentSuccess(), other.edgeDeploymentSuccess()) && Objects.equals(this.edgeDeploymentPending(), other.edgeDeploymentPending()) && Objects.equals(this.edgeDeploymentFailed(), other.edgeDeploymentFailed()) && this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEdgeDeploymentPlanResponse").add("EdgeDeploymentPlanArn", (Object)this.edgeDeploymentPlanArn()).add("EdgeDeploymentPlanName", (Object)this.edgeDeploymentPlanName()).add("ModelConfigs", this.hasModelConfigs() ? this.modelConfigs() : null).add("DeviceFleetName", (Object)this.deviceFleetName()).add("EdgeDeploymentSuccess", (Object)this.edgeDeploymentSuccess()).add("EdgeDeploymentPending", (Object)this.edgeDeploymentPending()).add("EdgeDeploymentFailed", (Object)this.edgeDeploymentFailed()).add("Stages", this.hasStages() ? this.stages() : null).add("NextToken", (Object)this.nextToken()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeDeploymentPlanArn": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanArn()));
            }
            case "EdgeDeploymentPlanName": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanName()));
            }
            case "ModelConfigs": {
                return Optional.ofNullable(clazz.cast(this.modelConfigs()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "EdgeDeploymentSuccess": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentSuccess()));
            }
            case "EdgeDeploymentPending": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPending()));
            }
            case "EdgeDeploymentFailed": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentFailed()));
            }
            case "Stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EdgeDeploymentPlanArn", EDGE_DEPLOYMENT_PLAN_ARN_FIELD);
        map.put("EdgeDeploymentPlanName", EDGE_DEPLOYMENT_PLAN_NAME_FIELD);
        map.put("ModelConfigs", MODEL_CONFIGS_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("EdgeDeploymentSuccess", EDGE_DEPLOYMENT_SUCCESS_FIELD);
        map.put("EdgeDeploymentPending", EDGE_DEPLOYMENT_PENDING_FIELD);
        map.put("EdgeDeploymentFailed", EDGE_DEPLOYMENT_FAILED_FIELD);
        map.put("Stages", STAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEdgeDeploymentPlanResponse, T> g) {
        return obj -> g.apply((DescribeEdgeDeploymentPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String edgeDeploymentPlanArn;
        private String edgeDeploymentPlanName;
        private List<EdgeDeploymentModelConfig> modelConfigs = DefaultSdkAutoConstructList.getInstance();
        private String deviceFleetName;
        private Integer edgeDeploymentSuccess;
        private Integer edgeDeploymentPending;
        private Integer edgeDeploymentFailed;
        private List<DeploymentStageStatusSummary> stages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEdgeDeploymentPlanResponse model) {
            super(model);
            this.edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
            this.edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            this.modelConfigs(model.modelConfigs);
            this.deviceFleetName(model.deviceFleetName);
            this.edgeDeploymentSuccess(model.edgeDeploymentSuccess);
            this.edgeDeploymentPending(model.edgeDeploymentPending);
            this.edgeDeploymentFailed(model.edgeDeploymentFailed);
            this.stages(model.stages);
            this.nextToken(model.nextToken);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEdgeDeploymentPlanArn() {
            return this.edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return this.edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final List<EdgeDeploymentModelConfig.Builder> getModelConfigs() {
            List<EdgeDeploymentModelConfig.Builder> result = EdgeDeploymentModelConfigsCopier.copyToBuilder(this.modelConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelConfigs(Collection<EdgeDeploymentModelConfig.BuilderImpl> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copyFromBuilder(modelConfigs);
        }

        @Override
        public final Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copy(modelConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(EdgeDeploymentModelConfig ... modelConfigs) {
            this.modelConfigs(Arrays.asList(modelConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder> ... modelConfigs) {
            this.modelConfigs(Stream.of(modelConfigs).map(c -> (EdgeDeploymentModelConfig)((EdgeDeploymentModelConfig.Builder)EdgeDeploymentModelConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final Integer getEdgeDeploymentSuccess() {
            return this.edgeDeploymentSuccess;
        }

        public final void setEdgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
        }

        @Override
        public final Builder edgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
            return this;
        }

        public final Integer getEdgeDeploymentPending() {
            return this.edgeDeploymentPending;
        }

        public final void setEdgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
        }

        @Override
        public final Builder edgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
            return this;
        }

        public final Integer getEdgeDeploymentFailed() {
            return this.edgeDeploymentFailed;
        }

        public final void setEdgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
        }

        @Override
        public final Builder edgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
            return this;
        }

        public final List<DeploymentStageStatusSummary.Builder> getStages() {
            List<DeploymentStageStatusSummary.Builder> result = DeploymentStageStatusSummariesCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<DeploymentStageStatusSummary.BuilderImpl> stages) {
            this.stages = DeploymentStageStatusSummariesCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<DeploymentStageStatusSummary> stages) {
            this.stages = DeploymentStageStatusSummariesCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(DeploymentStageStatusSummary ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<DeploymentStageStatusSummary.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (DeploymentStageStatusSummary)((DeploymentStageStatusSummary.Builder)DeploymentStageStatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeEdgeDeploymentPlanResponse build() {
            return new DescribeEdgeDeploymentPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEdgeDeploymentPlanResponse> {
        public Builder edgeDeploymentPlanArn(String var1);

        public Builder edgeDeploymentPlanName(String var1);

        public Builder modelConfigs(Collection<EdgeDeploymentModelConfig> var1);

        public Builder modelConfigs(EdgeDeploymentModelConfig ... var1);

        public Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder> ... var1);

        public Builder deviceFleetName(String var1);

        public Builder edgeDeploymentSuccess(Integer var1);

        public Builder edgeDeploymentPending(Integer var1);

        public Builder edgeDeploymentFailed(Integer var1);

        public Builder stages(Collection<DeploymentStageStatusSummary> var1);

        public Builder stages(DeploymentStageStatusSummary ... var1);

        public Builder stages(Consumer<DeploymentStageStatusSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

