/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.OutputParameter;
import software.amazon.awssdk.services.sagemaker.model.OutputParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaStepMetadata> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(LambdaStepMetadata.getter(LambdaStepMetadata::arn)).setter(LambdaStepMetadata.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<OutputParameter>> OUTPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputParameters").getter(LambdaStepMetadata.getter(LambdaStepMetadata::outputParameters)).setter(LambdaStepMetadata.setter(Builder::outputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OUTPUT_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaStepMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<OutputParameter> outputParameters;

    private LambdaStepMetadata(BuilderImpl builder) {
        this.arn = builder.arn;
        this.outputParameters = builder.outputParameters;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasOutputParameters() {
        return this.outputParameters != null && !(this.outputParameters instanceof SdkAutoConstructList);
    }

    public final List<OutputParameter> outputParameters() {
        return this.outputParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputParameters() ? this.outputParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaStepMetadata)) {
            return false;
        }
        LambdaStepMetadata other = (LambdaStepMetadata)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasOutputParameters() == other.hasOutputParameters() && Objects.equals(this.outputParameters(), other.outputParameters());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaStepMetadata").add("Arn", (Object)this.arn()).add("OutputParameters", this.hasOutputParameters() ? this.outputParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OutputParameters": {
                return Optional.ofNullable(clazz.cast(this.outputParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("OutputParameters", OUTPUT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaStepMetadata, T> g) {
        return obj -> g.apply((LambdaStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<OutputParameter> outputParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaStepMetadata model) {
            this.arn(model.arn);
            this.outputParameters(model.outputParameters);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<OutputParameter.Builder> getOutputParameters() {
            List<OutputParameter.Builder> result = OutputParameterListCopier.copyToBuilder(this.outputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputParameters(Collection<OutputParameter.BuilderImpl> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copyFromBuilder(outputParameters);
        }

        @Override
        public final Builder outputParameters(Collection<OutputParameter> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copy(outputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputParameters(OutputParameter ... outputParameters) {
            this.outputParameters(Arrays.asList(outputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputParameters(Consumer<OutputParameter.Builder> ... outputParameters) {
            this.outputParameters(Stream.of(outputParameters).map(c -> (OutputParameter)((OutputParameter.Builder)OutputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LambdaStepMetadata build() {
            return new LambdaStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaStepMetadata> {
        public Builder arn(String var1);

        public Builder outputParameters(Collection<OutputParameter> var1);

        public Builder outputParameters(OutputParameter ... var1);

        public Builder outputParameters(Consumer<OutputParameter.Builder> ... var1);
    }
}

