/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType;
import software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FinalAutoMLJobObjectiveMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FinalAutoMLJobObjectiveMetric> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FinalAutoMLJobObjectiveMetric.getter(FinalAutoMLJobObjectiveMetric::typeAsString)).setter(FinalAutoMLJobObjectiveMetric.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(FinalAutoMLJobObjectiveMetric.getter(FinalAutoMLJobObjectiveMetric::metricNameAsString)).setter(FinalAutoMLJobObjectiveMetric.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<Float> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Value").getter(FinalAutoMLJobObjectiveMetric.getter(FinalAutoMLJobObjectiveMetric::value)).setter(FinalAutoMLJobObjectiveMetric.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> STANDARD_METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardMetricName").getter(FinalAutoMLJobObjectiveMetric.getter(FinalAutoMLJobObjectiveMetric::standardMetricNameAsString)).setter(FinalAutoMLJobObjectiveMetric.setter(Builder::standardMetricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardMetricName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD, VALUE_FIELD, STANDARD_METRIC_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FinalAutoMLJobObjectiveMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String metricName;
    private final Float value;
    private final String standardMetricName;

    private FinalAutoMLJobObjectiveMetric(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.value = builder.value;
        this.standardMetricName = builder.standardMetricName;
    }

    public final AutoMLJobObjectiveType type() {
        return AutoMLJobObjectiveType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AutoMLMetricEnum metricName() {
        return AutoMLMetricEnum.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final Float value() {
        return this.value;
    }

    public final AutoMLMetricEnum standardMetricName() {
        return AutoMLMetricEnum.fromValue(this.standardMetricName);
    }

    public final String standardMetricNameAsString() {
        return this.standardMetricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardMetricNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinalAutoMLJobObjectiveMetric)) {
            return false;
        }
        FinalAutoMLJobObjectiveMetric other = (FinalAutoMLJobObjectiveMetric)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.standardMetricNameAsString(), other.standardMetricNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FinalAutoMLJobObjectiveMetric").add("Type", (Object)this.typeAsString()).add("MetricName", (Object)this.metricNameAsString()).add("Value", (Object)this.value()).add("StandardMetricName", (Object)this.standardMetricNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "StandardMetricName": {
                return Optional.ofNullable(clazz.cast(this.standardMetricNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("StandardMetricName", STANDARD_METRIC_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FinalAutoMLJobObjectiveMetric, T> g) {
        return obj -> g.apply((FinalAutoMLJobObjectiveMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String metricName;
        private Float value;
        private String standardMetricName;

        private BuilderImpl() {
        }

        private BuilderImpl(FinalAutoMLJobObjectiveMetric model) {
            this.type(model.type);
            this.metricName(model.metricName);
            this.value(model.value);
            this.standardMetricName(model.standardMetricName);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutoMLJobObjectiveType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(AutoMLMetricEnum metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final Float getValue() {
            return this.value;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        public final String getStandardMetricName() {
            return this.standardMetricName;
        }

        public final void setStandardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
        }

        @Override
        public final Builder standardMetricName(String standardMetricName) {
            this.standardMetricName = standardMetricName;
            return this;
        }

        @Override
        public final Builder standardMetricName(AutoMLMetricEnum standardMetricName) {
            this.standardMetricName(standardMetricName == null ? null : standardMetricName.toString());
            return this;
        }

        public FinalAutoMLJobObjectiveMetric build() {
            return new FinalAutoMLJobObjectiveMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FinalAutoMLJobObjectiveMetric> {
        public Builder type(String var1);

        public Builder type(AutoMLJobObjectiveType var1);

        public Builder metricName(String var1);

        public Builder metricName(AutoMLMetricEnum var1);

        public Builder value(Float var1);

        public Builder standardMetricName(String var1);

        public Builder standardMetricName(AutoMLMetricEnum var1);
    }
}

