/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobDeploymentInstanceType;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.OptimizationTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationJobSummary> {
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobName").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationJobName)).setter(OptimizationJobSummary.setter(Builder::optimizationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build()}).build();
    private static final SdkField<String> OPTIMIZATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobArn").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationJobArn)).setter(OptimizationJobSummary.setter(Builder::optimizationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(OptimizationJobSummary.getter(OptimizationJobSummary::creationTime)).setter(OptimizationJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> OPTIMIZATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationJobStatus").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationJobStatusAsString)).setter(OptimizationJobSummary.setter(Builder::optimizationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobStatus").build()}).build();
    private static final SdkField<Instant> OPTIMIZATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OptimizationStartTime").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationStartTime)).setter(OptimizationJobSummary.setter(Builder::optimizationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStartTime").build()}).build();
    private static final SdkField<Instant> OPTIMIZATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OptimizationEndTime").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationEndTime)).setter(OptimizationJobSummary.setter(Builder::optimizationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(OptimizationJobSummary.getter(OptimizationJobSummary::lastModifiedTime)).setter(OptimizationJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentInstanceType").getter(OptimizationJobSummary.getter(OptimizationJobSummary::deploymentInstanceTypeAsString)).setter(OptimizationJobSummary.setter(Builder::deploymentInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build()}).build();
    private static final SdkField<List<String>> OPTIMIZATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptimizationTypes").getter(OptimizationJobSummary.getter(OptimizationJobSummary::optimizationTypes)).setter(OptimizationJobSummary.setter(Builder::optimizationTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_NAME_FIELD, OPTIMIZATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, OPTIMIZATION_JOB_STATUS_FIELD, OPTIMIZATION_START_TIME_FIELD, OPTIMIZATION_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String optimizationJobName;
    private final String optimizationJobArn;
    private final Instant creationTime;
    private final String optimizationJobStatus;
    private final Instant optimizationStartTime;
    private final Instant optimizationEndTime;
    private final Instant lastModifiedTime;
    private final String deploymentInstanceType;
    private final List<String> optimizationTypes;

    private OptimizationJobSummary(BuilderImpl builder) {
        this.optimizationJobName = builder.optimizationJobName;
        this.optimizationJobArn = builder.optimizationJobArn;
        this.creationTime = builder.creationTime;
        this.optimizationJobStatus = builder.optimizationJobStatus;
        this.optimizationStartTime = builder.optimizationStartTime;
        this.optimizationEndTime = builder.optimizationEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationTypes = builder.optimizationTypes;
    }

    public final String optimizationJobName() {
        return this.optimizationJobName;
    }

    public final String optimizationJobArn() {
        return this.optimizationJobArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final OptimizationJobStatus optimizationJobStatus() {
        return OptimizationJobStatus.fromValue(this.optimizationJobStatus);
    }

    public final String optimizationJobStatusAsString() {
        return this.optimizationJobStatus;
    }

    public final Instant optimizationStartTime() {
        return this.optimizationStartTime;
    }

    public final Instant optimizationEndTime() {
        return this.optimizationEndTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(this.deploymentInstanceType);
    }

    public final String deploymentInstanceTypeAsString() {
        return this.deploymentInstanceType;
    }

    public final boolean hasOptimizationTypes() {
        return this.optimizationTypes != null && !(this.optimizationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> optimizationTypes() {
        return this.optimizationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizationTypes() ? this.optimizationTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobSummary)) {
            return false;
        }
        OptimizationJobSummary other = (OptimizationJobSummary)obj;
        return Objects.equals(this.optimizationJobName(), other.optimizationJobName()) && Objects.equals(this.optimizationJobArn(), other.optimizationJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.optimizationJobStatusAsString(), other.optimizationJobStatusAsString()) && Objects.equals(this.optimizationStartTime(), other.optimizationStartTime()) && Objects.equals(this.optimizationEndTime(), other.optimizationEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString()) && this.hasOptimizationTypes() == other.hasOptimizationTypes() && Objects.equals(this.optimizationTypes(), other.optimizationTypes());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationJobSummary").add("OptimizationJobName", (Object)this.optimizationJobName()).add("OptimizationJobArn", (Object)this.optimizationJobArn()).add("CreationTime", (Object)this.creationTime()).add("OptimizationJobStatus", (Object)this.optimizationJobStatusAsString()).add("OptimizationStartTime", (Object)this.optimizationStartTime()).add("OptimizationEndTime", (Object)this.optimizationEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DeploymentInstanceType", (Object)this.deploymentInstanceTypeAsString()).add("OptimizationTypes", this.hasOptimizationTypes() ? this.optimizationTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptimizationJobName": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobName()));
            }
            case "OptimizationJobArn": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OptimizationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.optimizationJobStatusAsString()));
            }
            case "OptimizationStartTime": {
                return Optional.ofNullable(clazz.cast(this.optimizationStartTime()));
            }
            case "OptimizationEndTime": {
                return Optional.ofNullable(clazz.cast(this.optimizationEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DeploymentInstanceType": {
                return Optional.ofNullable(clazz.cast(this.deploymentInstanceTypeAsString()));
            }
            case "OptimizationTypes": {
                return Optional.ofNullable(clazz.cast(this.optimizationTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptimizationJobName", OPTIMIZATION_JOB_NAME_FIELD);
        map.put("OptimizationJobArn", OPTIMIZATION_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("OptimizationJobStatus", OPTIMIZATION_JOB_STATUS_FIELD);
        map.put("OptimizationStartTime", OPTIMIZATION_START_TIME_FIELD);
        map.put("OptimizationEndTime", OPTIMIZATION_END_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DeploymentInstanceType", DEPLOYMENT_INSTANCE_TYPE_FIELD);
        map.put("OptimizationTypes", OPTIMIZATION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobSummary, T> g) {
        return obj -> g.apply((OptimizationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optimizationJobName;
        private String optimizationJobArn;
        private Instant creationTime;
        private String optimizationJobStatus;
        private Instant optimizationStartTime;
        private Instant optimizationEndTime;
        private Instant lastModifiedTime;
        private String deploymentInstanceType;
        private List<String> optimizationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobSummary model) {
            this.optimizationJobName(model.optimizationJobName);
            this.optimizationJobArn(model.optimizationJobArn);
            this.creationTime(model.creationTime);
            this.optimizationJobStatus(model.optimizationJobStatus);
            this.optimizationStartTime(model.optimizationStartTime);
            this.optimizationEndTime(model.optimizationEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.deploymentInstanceType(model.deploymentInstanceType);
            this.optimizationTypes(model.optimizationTypes);
        }

        public final String getOptimizationJobName() {
            return this.optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final String getOptimizationJobArn() {
            return this.optimizationJobArn;
        }

        public final void setOptimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
        }

        @Override
        public final Builder optimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOptimizationJobStatus() {
            return this.optimizationJobStatus;
        }

        public final void setOptimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
        }

        @Override
        public final Builder optimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
            return this;
        }

        @Override
        public final Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus) {
            this.optimizationJobStatus(optimizationJobStatus == null ? null : optimizationJobStatus.toString());
            return this;
        }

        public final Instant getOptimizationStartTime() {
            return this.optimizationStartTime;
        }

        public final void setOptimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
        }

        @Override
        public final Builder optimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
            return this;
        }

        public final Instant getOptimizationEndTime() {
            return this.optimizationEndTime;
        }

        public final void setOptimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
        }

        @Override
        public final Builder optimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDeploymentInstanceType() {
            return this.deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final Collection<String> getOptimizationTypes() {
            if (this.optimizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optimizationTypes;
        }

        public final void setOptimizationTypes(Collection<String> optimizationTypes) {
            this.optimizationTypes = OptimizationTypesCopier.copy(optimizationTypes);
        }

        @Override
        public final Builder optimizationTypes(Collection<String> optimizationTypes) {
            this.optimizationTypes = OptimizationTypesCopier.copy(optimizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationTypes(String ... optimizationTypes) {
            this.optimizationTypes(Arrays.asList(optimizationTypes));
            return this;
        }

        public OptimizationJobSummary build() {
            return new OptimizationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationJobSummary> {
        public Builder optimizationJobName(String var1);

        public Builder optimizationJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder optimizationJobStatus(String var1);

        public Builder optimizationJobStatus(OptimizationJobStatus var1);

        public Builder optimizationStartTime(Instant var1);

        public Builder optimizationEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder deploymentInstanceType(String var1);

        public Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType var1);

        public Builder optimizationTypes(Collection<String> var1);

        public Builder optimizationTypes(String ... var1);
    }
}

