/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeviceFleetRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateDeviceFleetRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::deviceFleetName)).setter(CreateDeviceFleetRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::roleArn)).setter(CreateDeviceFleetRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::description)).setter(CreateDeviceFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::outputConfig)).setter(CreateDeviceFleetRequest.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::tags)).setter(CreateDeviceFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_IOT_ROLE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIotRoleAlias").getter(CreateDeviceFleetRequest.getter(CreateDeviceFleetRequest::enableIotRoleAlias)).setter(CreateDeviceFleetRequest.setter(Builder::enableIotRoleAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIotRoleAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD, ENABLE_IOT_ROLE_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeviceFleetRequest.memberNameToFieldInitializer();
    private final String deviceFleetName;
    private final String roleArn;
    private final String description;
    private final EdgeOutputConfig outputConfig;
    private final List<Tag> tags;
    private final Boolean enableIotRoleAlias;

    private CreateDeviceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
        this.enableIotRoleAlias = builder.enableIotRoleAlias;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    public final EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean enableIotRoleAlias() {
        return this.enableIotRoleAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIotRoleAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceFleetRequest)) {
            return false;
        }
        CreateDeviceFleetRequest other = (CreateDeviceFleetRequest)((Object)obj);
        return Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableIotRoleAlias(), other.enableIotRoleAlias());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeviceFleetRequest").add("DeviceFleetName", (Object)this.deviceFleetName()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("OutputConfig", (Object)this.outputConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("EnableIotRoleAlias", (Object)this.enableIotRoleAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EnableIotRoleAlias": {
                return Optional.ofNullable(clazz.cast(this.enableIotRoleAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("EnableIotRoleAlias", ENABLE_IOT_ROLE_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeviceFleetRequest, T> g) {
        return obj -> g.apply((CreateDeviceFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String deviceFleetName;
        private String roleArn;
        private String description;
        private EdgeOutputConfig outputConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableIotRoleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceFleetRequest model) {
            super(model);
            this.deviceFleetName(model.deviceFleetName);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.outputConfig(model.outputConfig);
            this.tags(model.tags);
            this.enableIotRoleAlias(model.enableIotRoleAlias);
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableIotRoleAlias() {
            return this.enableIotRoleAlias;
        }

        public final void setEnableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
        }

        @Override
        public final Builder enableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceFleetRequest build() {
            return new CreateDeviceFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeviceFleetRequest> {
        public Builder deviceFleetName(String var1);

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableIotRoleAlias(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

