/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryPipelineExecutionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, RetryPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionArn").getter(RetryPipelineExecutionRequest.getter(RetryPipelineExecutionRequest::pipelineExecutionArn)).setter(RetryPipelineExecutionRequest.setter(Builder::pipelineExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(RetryPipelineExecutionRequest.getter(RetryPipelineExecutionRequest::clientRequestToken)).setter(RetryPipelineExecutionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelismConfiguration").getter(RetryPipelineExecutionRequest.getter(RetryPipelineExecutionRequest::parallelismConfiguration)).setter(RetryPipelineExecutionRequest.setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, PARALLELISM_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetryPipelineExecutionRequest.memberNameToFieldInitializer();
    private final String pipelineExecutionArn;
    private final String clientRequestToken;
    private final ParallelismConfiguration parallelismConfiguration;

    private RetryPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    public final String pipelineExecutionArn() {
        return this.pipelineExecutionArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final ParallelismConfiguration parallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPipelineExecutionRequest)) {
            return false;
        }
        RetryPipelineExecutionRequest other = (RetryPipelineExecutionRequest)((Object)obj);
        return Objects.equals(this.pipelineExecutionArn(), other.pipelineExecutionArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.parallelismConfiguration(), other.parallelismConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RetryPipelineExecutionRequest").add("PipelineExecutionArn", (Object)this.pipelineExecutionArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ParallelismConfiguration", (Object)this.parallelismConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionArn()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ParallelismConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineExecutionArn", PIPELINE_EXECUTION_ARN_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ParallelismConfiguration", PARALLELISM_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryPipelineExecutionRequest, T> g) {
        return obj -> g.apply((RetryPipelineExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineExecutionArn;
        private String clientRequestToken;
        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPipelineExecutionRequest model) {
            super(model);
            this.pipelineExecutionArn(model.pipelineExecutionArn);
            this.clientRequestToken(model.clientRequestToken);
            this.parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineExecutionArn() {
            return this.pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return this.parallelismConfiguration != null ? this.parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryPipelineExecutionRequest build() {
            return new RetryPipelineExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetryPipelineExecutionRequest> {
        public Builder pipelineExecutionArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder parallelismConfiguration(ParallelismConfiguration var1);

        default public Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return this.parallelismConfiguration((ParallelismConfiguration)((ParallelismConfiguration.Builder)ParallelismConfiguration.builder().applyMutation(parallelismConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

