/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.IamIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserContext> {
    private static final SdkField<String> USER_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileArn").getter(UserContext.getter(UserContext::userProfileArn)).setter(UserContext.setter(Builder::userProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileArn").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(UserContext.getter(UserContext::userProfileName)).setter(UserContext.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UserContext.getter(UserContext::domainId)).setter(UserContext.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<IamIdentity> IAM_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamIdentity").getter(UserContext.getter(UserContext::iamIdentity)).setter(UserContext.setter(Builder::iamIdentity)).constructor(IamIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILE_ARN_FIELD, USER_PROFILE_NAME_FIELD, DOMAIN_ID_FIELD, IAM_IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userProfileArn;
    private final String userProfileName;
    private final String domainId;
    private final IamIdentity iamIdentity;

    private UserContext(BuilderImpl builder) {
        this.userProfileArn = builder.userProfileArn;
        this.userProfileName = builder.userProfileName;
        this.domainId = builder.domainId;
        this.iamIdentity = builder.iamIdentity;
    }

    public final String userProfileArn() {
        return this.userProfileArn;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final IamIdentity iamIdentity() {
        return this.iamIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContext)) {
            return false;
        }
        UserContext other = (UserContext)obj;
        return Objects.equals(this.userProfileArn(), other.userProfileArn()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.iamIdentity(), other.iamIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"UserContext").add("UserProfileArn", (Object)this.userProfileArn()).add("UserProfileName", (Object)this.userProfileName()).add("DomainId", (Object)this.domainId()).add("IamIdentity", (Object)this.iamIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserProfileArn": {
                return Optional.ofNullable(clazz.cast(this.userProfileArn()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "IamIdentity": {
                return Optional.ofNullable(clazz.cast(this.iamIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserProfileArn", USER_PROFILE_ARN_FIELD);
        map.put("UserProfileName", USER_PROFILE_NAME_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("IamIdentity", IAM_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserContext, T> g) {
        return obj -> g.apply((UserContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userProfileArn;
        private String userProfileName;
        private String domainId;
        private IamIdentity iamIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(UserContext model) {
            this.userProfileArn(model.userProfileArn);
            this.userProfileName(model.userProfileName);
            this.domainId(model.domainId);
            this.iamIdentity(model.iamIdentity);
        }

        public final String getUserProfileArn() {
            return this.userProfileArn;
        }

        public final void setUserProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
        }

        @Override
        public final Builder userProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
            return this;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final IamIdentity.Builder getIamIdentity() {
            return this.iamIdentity != null ? this.iamIdentity.toBuilder() : null;
        }

        public final void setIamIdentity(IamIdentity.BuilderImpl iamIdentity) {
            this.iamIdentity = iamIdentity != null ? iamIdentity.build() : null;
        }

        @Override
        public final Builder iamIdentity(IamIdentity iamIdentity) {
            this.iamIdentity = iamIdentity;
            return this;
        }

        public UserContext build() {
            return new UserContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserContext> {
        public Builder userProfileArn(String var1);

        public Builder userProfileName(String var1);

        public Builder domainId(String var1);

        public Builder iamIdentity(IamIdentity var1);

        default public Builder iamIdentity(Consumer<IamIdentity.Builder> iamIdentity) {
            return this.iamIdentity((IamIdentity)((IamIdentity.Builder)IamIdentity.builder().applyMutation(iamIdentity)).build());
        }
    }
}

