/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserProfileDetails;
import software.amazon.awssdk.services.sagemaker.model.UserProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserProfilesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListUserProfilesResponse> {
    private static final SdkField<List<UserProfileDetails>> USER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserProfiles").getter(ListUserProfilesResponse.getter(ListUserProfilesResponse::userProfiles)).setter(ListUserProfilesResponse.setter(Builder::userProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProfileDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserProfilesResponse.getter(ListUserProfilesResponse::nextToken)).setter(ListUserProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUserProfilesResponse.memberNameToFieldInitializer();
    private final List<UserProfileDetails> userProfiles;
    private final String nextToken;

    private ListUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserProfiles() {
        return this.userProfiles != null && !(this.userProfiles instanceof SdkAutoConstructList);
    }

    public final List<UserProfileDetails> userProfiles() {
        return this.userProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProfiles() ? this.userProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProfilesResponse)) {
            return false;
        }
        ListUserProfilesResponse other = (ListUserProfilesResponse)((Object)obj);
        return this.hasUserProfiles() == other.hasUserProfiles() && Objects.equals(this.userProfiles(), other.userProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserProfilesResponse").add("UserProfiles", this.hasUserProfiles() ? this.userProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserProfiles": {
                return Optional.ofNullable(clazz.cast(this.userProfiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserProfiles", USER_PROFILES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserProfilesResponse, T> g) {
        return obj -> g.apply((ListUserProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<UserProfileDetails> userProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProfilesResponse model) {
            super(model);
            this.userProfiles(model.userProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<UserProfileDetails.Builder> getUserProfiles() {
            List<UserProfileDetails.Builder> result = UserProfileListCopier.copyToBuilder(this.userProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProfiles(Collection<UserProfileDetails.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfileListCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public final Builder userProfiles(Collection<UserProfileDetails> userProfiles) {
            this.userProfiles = UserProfileListCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfileDetails ... userProfiles) {
            this.userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfileDetails.Builder> ... userProfiles) {
            this.userProfiles(Stream.of(userProfiles).map(c -> (UserProfileDetails)((UserProfileDetails.Builder)UserProfileDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUserProfilesResponse build() {
            return new ListUserProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfileDetails> var1);

        public Builder userProfiles(UserProfileDetails ... var1);

        public Builder userProfiles(Consumer<UserProfileDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

