/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteClusterNodesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, BatchDeleteClusterNodesRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(BatchDeleteClusterNodesRequest.getter(BatchDeleteClusterNodesRequest::clusterName)).setter(BatchDeleteClusterNodesRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<List<String>> NODE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeIds").getter(BatchDeleteClusterNodesRequest.getter(BatchDeleteClusterNodesRequest::nodeIds)).setter(BatchDeleteClusterNodesRequest.setter(Builder::nodeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteClusterNodesRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final List<String> nodeIds;

    private BatchDeleteClusterNodesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeIds = builder.nodeIds;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasNodeIds() {
        return this.nodeIds != null && !(this.nodeIds instanceof SdkAutoConstructList);
    }

    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeIds() ? this.nodeIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodesRequest)) {
            return false;
        }
        BatchDeleteClusterNodesRequest other = (BatchDeleteClusterNodesRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasNodeIds() == other.hasNodeIds() && Objects.equals(this.nodeIds(), other.nodeIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteClusterNodesRequest").add("ClusterName", (Object)this.clusterName()).add("NodeIds", this.hasNodeIds() ? this.nodeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "NodeIds": {
                return Optional.ofNullable(clazz.cast(this.nodeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("NodeIds", NODE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodesRequest, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<String> nodeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodesRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodeIds(model.nodeIds);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Collection<String> getNodeIds() {
            if (this.nodeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeIds;
        }

        public final void setNodeIds(Collection<String> nodeIds) {
            this.nodeIds = ClusterNodeIdsCopier.copy(nodeIds);
        }

        @Override
        public final Builder nodeIds(Collection<String> nodeIds) {
            this.nodeIds = ClusterNodeIdsCopier.copy(nodeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIds(String ... nodeIds) {
            this.nodeIds(Arrays.asList(nodeIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteClusterNodesRequest build() {
            return new BatchDeleteClusterNodesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteClusterNodesRequest> {
        public Builder clusterName(String var1);

        public Builder nodeIds(Collection<String> var1);

        public Builder nodeIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

