/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EndpointInfo;
import software.amazon.awssdk.services.sagemaker.model.InferenceMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointPerformance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointPerformance> {
    private static final SdkField<InferenceMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metrics").getter(EndpointPerformance.getter(EndpointPerformance::metrics)).setter(EndpointPerformance.setter(Builder::metrics)).constructor(InferenceMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final SdkField<EndpointInfo> ENDPOINT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInfo").getter(EndpointPerformance.getter(EndpointPerformance::endpointInfo)).setter(EndpointPerformance.setter(Builder::endpointInfo)).constructor(EndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, ENDPOINT_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointPerformance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InferenceMetrics metrics;
    private final EndpointInfo endpointInfo;

    private EndpointPerformance(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.endpointInfo = builder.endpointInfo;
    }

    public final InferenceMetrics metrics() {
        return this.metrics;
    }

    public final EndpointInfo endpointInfo() {
        return this.endpointInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointPerformance)) {
            return false;
        }
        EndpointPerformance other = (EndpointPerformance)obj;
        return Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.endpointInfo(), other.endpointInfo());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointPerformance").add("Metrics", (Object)this.metrics()).add("EndpointInfo", (Object)this.endpointInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "EndpointInfo": {
                return Optional.ofNullable(clazz.cast(this.endpointInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Metrics", METRICS_FIELD);
        map.put("EndpointInfo", ENDPOINT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointPerformance, T> g) {
        return obj -> g.apply((EndpointPerformance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InferenceMetrics metrics;
        private EndpointInfo endpointInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointPerformance model) {
            this.metrics(model.metrics);
            this.endpointInfo(model.endpointInfo);
        }

        public final InferenceMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(InferenceMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(InferenceMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointInfo.Builder getEndpointInfo() {
            return this.endpointInfo != null ? this.endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(EndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(EndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public EndpointPerformance build() {
            return new EndpointPerformance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointPerformance> {
        public Builder metrics(InferenceMetrics var1);

        default public Builder metrics(Consumer<InferenceMetrics.Builder> metrics) {
            return this.metrics((InferenceMetrics)((InferenceMetrics.Builder)InferenceMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder endpointInfo(EndpointInfo var1);

        default public Builder endpointInfo(Consumer<EndpointInfo.Builder> endpointInfo) {
            return this.endpointInfo((EndpointInfo)((EndpointInfo.Builder)EndpointInfo.builder().applyMutation(endpointInfo)).build());
        }
    }
}

