/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsSortBy;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceRecommendationsJobsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListInferenceRecommendationsJobsRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::creationTimeAfter)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::creationTimeBefore)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeAfter").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::lastModifiedTimeAfter)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeBefore").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::lastModifiedTimeBefore)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::nameContains)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::statusEqualsAsString)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::sortByAsString)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::sortOrderAsString)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::nextToken)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::maxResults)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> MODEL_NAME_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelNameEquals").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::modelNameEquals)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::modelNameEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelNameEquals").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageVersionArnEquals").getter(ListInferenceRecommendationsJobsRequest.getter(ListInferenceRecommendationsJobsRequest::modelPackageVersionArnEquals)).setter(ListInferenceRecommendationsJobsRequest.setter(Builder::modelPackageVersionArnEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArnEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, MODEL_NAME_EQUALS_FIELD, MODEL_PACKAGE_VERSION_ARN_EQUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceRecommendationsJobsRequest.memberNameToFieldInitializer();
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final String nameContains;
    private final String statusEquals;
    private final String sortBy;
    private final String sortOrder;
    private final String nextToken;
    private final Integer maxResults;
    private final String modelNameEquals;
    private final String modelPackageVersionArnEquals;

    private ListInferenceRecommendationsJobsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.modelNameEquals = builder.modelNameEquals;
        this.modelPackageVersionArnEquals = builder.modelPackageVersionArnEquals;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public final Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final RecommendationJobStatus statusEquals() {
        return RecommendationJobStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final ListInferenceRecommendationsJobsSortBy sortBy() {
        return ListInferenceRecommendationsJobsSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String modelNameEquals() {
        return this.modelNameEquals;
    }

    public final String modelPackageVersionArnEquals() {
        return this.modelPackageVersionArnEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelNameEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersionArnEquals());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceRecommendationsJobsRequest)) {
            return false;
        }
        ListInferenceRecommendationsJobsRequest other = (ListInferenceRecommendationsJobsRequest)((Object)obj);
        return Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.modelNameEquals(), other.modelNameEquals()) && Objects.equals(this.modelPackageVersionArnEquals(), other.modelPackageVersionArnEquals());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceRecommendationsJobsRequest").add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("NameContains", (Object)this.nameContains()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ModelNameEquals", (Object)this.modelNameEquals()).add("ModelPackageVersionArnEquals", (Object)this.modelPackageVersionArnEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ModelNameEquals": {
                return Optional.ofNullable(clazz.cast(this.modelNameEquals()));
            }
            case "ModelPackageVersionArnEquals": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersionArnEquals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("LastModifiedTimeAfter", LAST_MODIFIED_TIME_AFTER_FIELD);
        map.put("LastModifiedTimeBefore", LAST_MODIFIED_TIME_BEFORE_FIELD);
        map.put("NameContains", NAME_CONTAINS_FIELD);
        map.put("StatusEquals", STATUS_EQUALS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ModelNameEquals", MODEL_NAME_EQUALS_FIELD);
        map.put("ModelPackageVersionArnEquals", MODEL_PACKAGE_VERSION_ARN_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceRecommendationsJobsRequest, T> g) {
        return obj -> g.apply((ListInferenceRecommendationsJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private Instant lastModifiedTimeAfter;
        private Instant lastModifiedTimeBefore;
        private String nameContains;
        private String statusEquals;
        private String sortBy;
        private String sortOrder;
        private String nextToken;
        private Integer maxResults;
        private String modelNameEquals;
        private String modelPackageVersionArnEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceRecommendationsJobsRequest model) {
            super(model);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.nameContains(model.nameContains);
            this.statusEquals(model.statusEquals);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.modelNameEquals(model.modelNameEquals);
            this.modelPackageVersionArnEquals(model.modelPackageVersionArnEquals);
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(RecommendationJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListInferenceRecommendationsJobsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getModelNameEquals() {
            return this.modelNameEquals;
        }

        public final void setModelNameEquals(String modelNameEquals) {
            this.modelNameEquals = modelNameEquals;
        }

        @Override
        public final Builder modelNameEquals(String modelNameEquals) {
            this.modelNameEquals = modelNameEquals;
            return this;
        }

        public final String getModelPackageVersionArnEquals() {
            return this.modelPackageVersionArnEquals;
        }

        public final void setModelPackageVersionArnEquals(String modelPackageVersionArnEquals) {
            this.modelPackageVersionArnEquals = modelPackageVersionArnEquals;
        }

        @Override
        public final Builder modelPackageVersionArnEquals(String modelPackageVersionArnEquals) {
            this.modelPackageVersionArnEquals = modelPackageVersionArnEquals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceRecommendationsJobsRequest build() {
            return new ListInferenceRecommendationsJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceRecommendationsJobsRequest> {
        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder nameContains(String var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(RecommendationJobStatus var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ListInferenceRecommendationsJobsSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder modelNameEquals(String var1);

        public Builder modelPackageVersionArnEquals(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

