/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleConfig> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(ScheduleConfig.getter(ScheduleConfig::scheduleExpression)).setter(ScheduleConfig.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<String> DATA_ANALYSIS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAnalysisStartTime").getter(ScheduleConfig.getter(ScheduleConfig::dataAnalysisStartTime)).setter(ScheduleConfig.setter(Builder::dataAnalysisStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAnalysisStartTime").build()}).build();
    private static final SdkField<String> DATA_ANALYSIS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAnalysisEndTime").getter(ScheduleConfig.getter(ScheduleConfig::dataAnalysisEndTime)).setter(ScheduleConfig.setter(Builder::dataAnalysisEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAnalysisEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, DATA_ANALYSIS_START_TIME_FIELD, DATA_ANALYSIS_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduleConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final String dataAnalysisStartTime;
    private final String dataAnalysisEndTime;

    private ScheduleConfig(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.dataAnalysisStartTime = builder.dataAnalysisStartTime;
        this.dataAnalysisEndTime = builder.dataAnalysisEndTime;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final String dataAnalysisStartTime() {
        return this.dataAnalysisStartTime;
    }

    public final String dataAnalysisEndTime() {
        return this.dataAnalysisEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAnalysisStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAnalysisEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfig)) {
            return false;
        }
        ScheduleConfig other = (ScheduleConfig)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.dataAnalysisStartTime(), other.dataAnalysisStartTime()) && Objects.equals(this.dataAnalysisEndTime(), other.dataAnalysisEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleConfig").add("ScheduleExpression", (Object)this.scheduleExpression()).add("DataAnalysisStartTime", (Object)this.dataAnalysisStartTime()).add("DataAnalysisEndTime", (Object)this.dataAnalysisEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "DataAnalysisStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataAnalysisStartTime()));
            }
            case "DataAnalysisEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataAnalysisEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("DataAnalysisStartTime", DATA_ANALYSIS_START_TIME_FIELD);
        map.put("DataAnalysisEndTime", DATA_ANALYSIS_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfig, T> g) {
        return obj -> g.apply((ScheduleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String dataAnalysisStartTime;
        private String dataAnalysisEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfig model) {
            this.scheduleExpression(model.scheduleExpression);
            this.dataAnalysisStartTime(model.dataAnalysisStartTime);
            this.dataAnalysisEndTime(model.dataAnalysisEndTime);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getDataAnalysisStartTime() {
            return this.dataAnalysisStartTime;
        }

        public final void setDataAnalysisStartTime(String dataAnalysisStartTime) {
            this.dataAnalysisStartTime = dataAnalysisStartTime;
        }

        @Override
        public final Builder dataAnalysisStartTime(String dataAnalysisStartTime) {
            this.dataAnalysisStartTime = dataAnalysisStartTime;
            return this;
        }

        public final String getDataAnalysisEndTime() {
            return this.dataAnalysisEndTime;
        }

        public final void setDataAnalysisEndTime(String dataAnalysisEndTime) {
            this.dataAnalysisEndTime = dataAnalysisEndTime;
        }

        @Override
        public final Builder dataAnalysisEndTime(String dataAnalysisEndTime) {
            this.dataAnalysisEndTime = dataAnalysisEndTime;
            return this;
        }

        public ScheduleConfig build() {
            return new ScheduleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleConfig> {
        public Builder scheduleExpression(String var1);

        public Builder dataAnalysisStartTime(String var1);

        public Builder dataAnalysisEndTime(String var1);
    }
}

