/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration;
import software.amazon.awssdk.services.sagemaker.model.PipelineDefinitionS3Location;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineName)).setter(UpdatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDisplayName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDisplayName)).setter(UpdatePipelineRequest.setter(Builder::pipelineDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDefinition").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDefinition)).setter(UpdatePipelineRequest.setter(Builder::pipelineDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build()}).build();
    private static final SdkField<PipelineDefinitionS3Location> PIPELINE_DEFINITION_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PipelineDefinitionS3Location").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDefinitionS3Location)).setter(UpdatePipelineRequest.setter(Builder::pipelineDefinitionS3Location)).constructor(PipelineDefinitionS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinitionS3Location").build()}).build();
    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDescription").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineDescription)).setter(UpdatePipelineRequest.setter(Builder::pipelineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::roleArn)).setter(UpdatePipelineRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelismConfiguration").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::parallelismConfiguration)).setter(UpdatePipelineRequest.setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DEFINITION_FIELD, PIPELINE_DEFINITION_S3_LOCATION_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD, PARALLELISM_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PipelineName", PIPELINE_NAME_FIELD);
            this.put("PipelineDisplayName", PIPELINE_DISPLAY_NAME_FIELD);
            this.put("PipelineDefinition", PIPELINE_DEFINITION_FIELD);
            this.put("PipelineDefinitionS3Location", PIPELINE_DEFINITION_S3_LOCATION_FIELD);
            this.put("PipelineDescription", PIPELINE_DESCRIPTION_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("ParallelismConfiguration", PARALLELISM_CONFIGURATION_FIELD);
        }
    });
    private final String pipelineName;
    private final String pipelineDisplayName;
    private final String pipelineDefinition;
    private final PipelineDefinitionS3Location pipelineDefinitionS3Location;
    private final String pipelineDescription;
    private final String roleArn;
    private final ParallelismConfiguration parallelismConfiguration;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDefinition = builder.pipelineDefinition;
        this.pipelineDefinitionS3Location = builder.pipelineDefinitionS3Location;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineDisplayName() {
        return this.pipelineDisplayName;
    }

    public final String pipelineDefinition() {
        return this.pipelineDefinition;
    }

    public final PipelineDefinitionS3Location pipelineDefinitionS3Location() {
        return this.pipelineDefinitionS3Location;
    }

    public final String pipelineDescription() {
        return this.pipelineDescription;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ParallelismConfiguration parallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDefinitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineDisplayName(), other.pipelineDisplayName()) && Objects.equals(this.pipelineDefinition(), other.pipelineDefinition()) && Objects.equals(this.pipelineDefinitionS3Location(), other.pipelineDefinitionS3Location()) && Objects.equals(this.pipelineDescription(), other.pipelineDescription()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.parallelismConfiguration(), other.parallelismConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineDisplayName", (Object)this.pipelineDisplayName()).add("PipelineDefinition", (Object)this.pipelineDefinition()).add("PipelineDefinitionS3Location", (Object)this.pipelineDefinitionS3Location()).add("PipelineDescription", (Object)this.pipelineDescription()).add("RoleArn", (Object)this.roleArn()).add("ParallelismConfiguration", (Object)this.parallelismConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineDisplayName()));
            }
            case "PipelineDefinition": {
                return Optional.ofNullable(clazz.cast(this.pipelineDefinition()));
            }
            case "PipelineDefinitionS3Location": {
                return Optional.ofNullable(clazz.cast(this.pipelineDefinitionS3Location()));
            }
            case "PipelineDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineDescription()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ParallelismConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineDisplayName;
        private String pipelineDefinition;
        private PipelineDefinitionS3Location pipelineDefinitionS3Location;
        private String pipelineDescription;
        private String roleArn;
        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineDisplayName(model.pipelineDisplayName);
            this.pipelineDefinition(model.pipelineDefinition);
            this.pipelineDefinitionS3Location(model.pipelineDefinitionS3Location);
            this.pipelineDescription(model.pipelineDescription);
            this.roleArn(model.roleArn);
            this.parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return this.pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDefinition() {
            return this.pipelineDefinition;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final PipelineDefinitionS3Location.Builder getPipelineDefinitionS3Location() {
            return this.pipelineDefinitionS3Location != null ? this.pipelineDefinitionS3Location.toBuilder() : null;
        }

        public final void setPipelineDefinitionS3Location(PipelineDefinitionS3Location.BuilderImpl pipelineDefinitionS3Location) {
            this.pipelineDefinitionS3Location = pipelineDefinitionS3Location != null ? pipelineDefinitionS3Location.build() : null;
        }

        @Override
        public final Builder pipelineDefinitionS3Location(PipelineDefinitionS3Location pipelineDefinitionS3Location) {
            this.pipelineDefinitionS3Location = pipelineDefinitionS3Location;
            return this;
        }

        public final String getPipelineDescription() {
            return this.pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return this.parallelismConfiguration != null ? this.parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineDisplayName(String var1);

        public Builder pipelineDefinition(String var1);

        public Builder pipelineDefinitionS3Location(PipelineDefinitionS3Location var1);

        default public Builder pipelineDefinitionS3Location(Consumer<PipelineDefinitionS3Location.Builder> pipelineDefinitionS3Location) {
            return this.pipelineDefinitionS3Location((PipelineDefinitionS3Location)((PipelineDefinitionS3Location.Builder)PipelineDefinitionS3Location.builder().applyMutation(pipelineDefinitionS3Location)).build());
        }

        public Builder pipelineDescription(String var1);

        public Builder roleArn(String var1);

        public Builder parallelismConfiguration(ParallelismConfiguration var1);

        default public Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return this.parallelismConfiguration((ParallelismConfiguration)((ParallelismConfiguration.Builder)ParallelismConfiguration.builder().applyMutation(parallelismConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

