/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypeListCopier;
import software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncInferenceNotificationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncInferenceNotificationConfig> {
    private static final SdkField<String> SUCCESS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuccessTopic").getter(AsyncInferenceNotificationConfig.getter(AsyncInferenceNotificationConfig::successTopic)).setter(AsyncInferenceNotificationConfig.setter(Builder::successTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessTopic").build()}).build();
    private static final SdkField<String> ERROR_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorTopic").getter(AsyncInferenceNotificationConfig.getter(AsyncInferenceNotificationConfig::errorTopic)).setter(AsyncInferenceNotificationConfig.setter(Builder::errorTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorTopic").build()}).build();
    private static final SdkField<List<String>> INCLUDE_INFERENCE_RESPONSE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeInferenceResponseIn").getter(AsyncInferenceNotificationConfig.getter(AsyncInferenceNotificationConfig::includeInferenceResponseInAsStrings)).setter(AsyncInferenceNotificationConfig.setter(Builder::includeInferenceResponseInWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeInferenceResponseIn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_TOPIC_FIELD, ERROR_TOPIC_FIELD, INCLUDE_INFERENCE_RESPONSE_IN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AsyncInferenceNotificationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String successTopic;
    private final String errorTopic;
    private final List<String> includeInferenceResponseIn;

    private AsyncInferenceNotificationConfig(BuilderImpl builder) {
        this.successTopic = builder.successTopic;
        this.errorTopic = builder.errorTopic;
        this.includeInferenceResponseIn = builder.includeInferenceResponseIn;
    }

    public final String successTopic() {
        return this.successTopic;
    }

    public final String errorTopic() {
        return this.errorTopic;
    }

    public final List<AsyncNotificationTopicTypes> includeInferenceResponseIn() {
        return AsyncNotificationTopicTypeListCopier.copyStringToEnum(this.includeInferenceResponseIn);
    }

    public final boolean hasIncludeInferenceResponseIn() {
        return this.includeInferenceResponseIn != null && !(this.includeInferenceResponseIn instanceof SdkAutoConstructList);
    }

    public final List<String> includeInferenceResponseInAsStrings() {
        return this.includeInferenceResponseIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeInferenceResponseIn() ? this.includeInferenceResponseInAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceNotificationConfig)) {
            return false;
        }
        AsyncInferenceNotificationConfig other = (AsyncInferenceNotificationConfig)obj;
        return Objects.equals(this.successTopic(), other.successTopic()) && Objects.equals(this.errorTopic(), other.errorTopic()) && this.hasIncludeInferenceResponseIn() == other.hasIncludeInferenceResponseIn() && Objects.equals(this.includeInferenceResponseInAsStrings(), other.includeInferenceResponseInAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncInferenceNotificationConfig").add("SuccessTopic", (Object)this.successTopic()).add("ErrorTopic", (Object)this.errorTopic()).add("IncludeInferenceResponseIn", this.hasIncludeInferenceResponseIn() ? this.includeInferenceResponseInAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessTopic": {
                return Optional.ofNullable(clazz.cast(this.successTopic()));
            }
            case "ErrorTopic": {
                return Optional.ofNullable(clazz.cast(this.errorTopic()));
            }
            case "IncludeInferenceResponseIn": {
                return Optional.ofNullable(clazz.cast(this.includeInferenceResponseInAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuccessTopic", SUCCESS_TOPIC_FIELD);
        map.put("ErrorTopic", ERROR_TOPIC_FIELD);
        map.put("IncludeInferenceResponseIn", INCLUDE_INFERENCE_RESPONSE_IN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceNotificationConfig, T> g) {
        return obj -> g.apply((AsyncInferenceNotificationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String successTopic;
        private String errorTopic;
        private List<String> includeInferenceResponseIn = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceNotificationConfig model) {
            this.successTopic(model.successTopic);
            this.errorTopic(model.errorTopic);
            this.includeInferenceResponseInWithStrings(model.includeInferenceResponseIn);
        }

        public final String getSuccessTopic() {
            return this.successTopic;
        }

        public final void setSuccessTopic(String successTopic) {
            this.successTopic = successTopic;
        }

        @Override
        public final Builder successTopic(String successTopic) {
            this.successTopic = successTopic;
            return this;
        }

        public final String getErrorTopic() {
            return this.errorTopic;
        }

        public final void setErrorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
        }

        @Override
        public final Builder errorTopic(String errorTopic) {
            this.errorTopic = errorTopic;
            return this;
        }

        public final Collection<String> getIncludeInferenceResponseIn() {
            if (this.includeInferenceResponseIn instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeInferenceResponseIn;
        }

        public final void setIncludeInferenceResponseIn(Collection<String> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copy(includeInferenceResponseIn);
        }

        @Override
        public final Builder includeInferenceResponseInWithStrings(Collection<String> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copy(includeInferenceResponseIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeInferenceResponseInWithStrings(String ... includeInferenceResponseIn) {
            this.includeInferenceResponseInWithStrings(Arrays.asList(includeInferenceResponseIn));
            return this;
        }

        @Override
        public final Builder includeInferenceResponseIn(Collection<AsyncNotificationTopicTypes> includeInferenceResponseIn) {
            this.includeInferenceResponseIn = AsyncNotificationTopicTypeListCopier.copyEnumToString(includeInferenceResponseIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeInferenceResponseIn(AsyncNotificationTopicTypes ... includeInferenceResponseIn) {
            this.includeInferenceResponseIn(Arrays.asList(includeInferenceResponseIn));
            return this;
        }

        public AsyncInferenceNotificationConfig build() {
            return new AsyncInferenceNotificationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncInferenceNotificationConfig> {
        public Builder successTopic(String var1);

        public Builder errorTopic(String var1);

        public Builder includeInferenceResponseInWithStrings(Collection<String> var1);

        public Builder includeInferenceResponseInWithStrings(String ... var1);

        public Builder includeInferenceResponseIn(Collection<AsyncNotificationTopicTypes> var1);

        public Builder includeInferenceResponseIn(AsyncNotificationTopicTypes ... var1);
    }
}

