/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAccessMode;
import software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingImageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingImageConfig> {
    private static final SdkField<String> TRAINING_REPOSITORY_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingRepositoryAccessMode").getter(TrainingImageConfig.getter(TrainingImageConfig::trainingRepositoryAccessModeAsString)).setter(TrainingImageConfig.setter(Builder::trainingRepositoryAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingRepositoryAccessMode").build()}).build();
    private static final SdkField<TrainingRepositoryAuthConfig> TRAINING_REPOSITORY_AUTH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingRepositoryAuthConfig").getter(TrainingImageConfig.getter(TrainingImageConfig::trainingRepositoryAuthConfig)).setter(TrainingImageConfig.setter(Builder::trainingRepositoryAuthConfig)).constructor(TrainingRepositoryAuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingRepositoryAuthConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_REPOSITORY_ACCESS_MODE_FIELD, TRAINING_REPOSITORY_AUTH_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrainingRepositoryAccessMode", TRAINING_REPOSITORY_ACCESS_MODE_FIELD);
            this.put("TrainingRepositoryAuthConfig", TRAINING_REPOSITORY_AUTH_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String trainingRepositoryAccessMode;
    private final TrainingRepositoryAuthConfig trainingRepositoryAuthConfig;

    private TrainingImageConfig(BuilderImpl builder) {
        this.trainingRepositoryAccessMode = builder.trainingRepositoryAccessMode;
        this.trainingRepositoryAuthConfig = builder.trainingRepositoryAuthConfig;
    }

    public final TrainingRepositoryAccessMode trainingRepositoryAccessMode() {
        return TrainingRepositoryAccessMode.fromValue(this.trainingRepositoryAccessMode);
    }

    public final String trainingRepositoryAccessModeAsString() {
        return this.trainingRepositoryAccessMode;
    }

    public final TrainingRepositoryAuthConfig trainingRepositoryAuthConfig() {
        return this.trainingRepositoryAuthConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingRepositoryAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingRepositoryAuthConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingImageConfig)) {
            return false;
        }
        TrainingImageConfig other = (TrainingImageConfig)obj;
        return Objects.equals(this.trainingRepositoryAccessModeAsString(), other.trainingRepositoryAccessModeAsString()) && Objects.equals(this.trainingRepositoryAuthConfig(), other.trainingRepositoryAuthConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingImageConfig").add("TrainingRepositoryAccessMode", (Object)this.trainingRepositoryAccessModeAsString()).add("TrainingRepositoryAuthConfig", (Object)this.trainingRepositoryAuthConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingRepositoryAccessMode": {
                return Optional.ofNullable(clazz.cast(this.trainingRepositoryAccessModeAsString()));
            }
            case "TrainingRepositoryAuthConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingRepositoryAuthConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrainingImageConfig, T> g) {
        return obj -> g.apply((TrainingImageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingRepositoryAccessMode;
        private TrainingRepositoryAuthConfig trainingRepositoryAuthConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingImageConfig model) {
            this.trainingRepositoryAccessMode(model.trainingRepositoryAccessMode);
            this.trainingRepositoryAuthConfig(model.trainingRepositoryAuthConfig);
        }

        public final String getTrainingRepositoryAccessMode() {
            return this.trainingRepositoryAccessMode;
        }

        public final void setTrainingRepositoryAccessMode(String trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode = trainingRepositoryAccessMode;
        }

        @Override
        public final Builder trainingRepositoryAccessMode(String trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode = trainingRepositoryAccessMode;
            return this;
        }

        @Override
        public final Builder trainingRepositoryAccessMode(TrainingRepositoryAccessMode trainingRepositoryAccessMode) {
            this.trainingRepositoryAccessMode(trainingRepositoryAccessMode == null ? null : trainingRepositoryAccessMode.toString());
            return this;
        }

        public final TrainingRepositoryAuthConfig.Builder getTrainingRepositoryAuthConfig() {
            return this.trainingRepositoryAuthConfig != null ? this.trainingRepositoryAuthConfig.toBuilder() : null;
        }

        public final void setTrainingRepositoryAuthConfig(TrainingRepositoryAuthConfig.BuilderImpl trainingRepositoryAuthConfig) {
            this.trainingRepositoryAuthConfig = trainingRepositoryAuthConfig != null ? trainingRepositoryAuthConfig.build() : null;
        }

        @Override
        public final Builder trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig trainingRepositoryAuthConfig) {
            this.trainingRepositoryAuthConfig = trainingRepositoryAuthConfig;
            return this;
        }

        public TrainingImageConfig build() {
            return new TrainingImageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingImageConfig> {
        public Builder trainingRepositoryAccessMode(String var1);

        public Builder trainingRepositoryAccessMode(TrainingRepositoryAccessMode var1);

        public Builder trainingRepositoryAuthConfig(TrainingRepositoryAuthConfig var1);

        default public Builder trainingRepositoryAuthConfig(Consumer<TrainingRepositoryAuthConfig.Builder> trainingRepositoryAuthConfig) {
            return this.trainingRepositoryAuthConfig((TrainingRepositoryAuthConfig)((TrainingRepositoryAuthConfig.Builder)TrainingRepositoryAuthConfig.builder().applyMutation(trainingRepositoryAuthConfig)).build());
        }
    }
}

