/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.NetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.ProcessingEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ProcessingInput;
import software.amazon.awssdk.services.sagemaker.model.ProcessingInputsCopier;
import software.amazon.awssdk.services.sagemaker.model.ProcessingOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.ProcessingResources;
import software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProcessingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateProcessingJobRequest> {
    private static final SdkField<List<ProcessingInput>> PROCESSING_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessingInputs").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::processingInputs)).setter(CreateProcessingJobRequest.setter(Builder::processingInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessingInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProcessingOutputConfig> PROCESSING_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingOutputConfig").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::processingOutputConfig)).setter(CreateProcessingJobRequest.setter(Builder::processingOutputConfig)).constructor(ProcessingOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingOutputConfig").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobName").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::processingJobName)).setter(CreateProcessingJobRequest.setter(Builder::processingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()}).build();
    private static final SdkField<ProcessingResources> PROCESSING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingResources").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::processingResources)).setter(CreateProcessingJobRequest.setter(Builder::processingResources)).constructor(ProcessingResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResources").build()}).build();
    private static final SdkField<ProcessingStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::stoppingCondition)).setter(CreateProcessingJobRequest.setter(Builder::stoppingCondition)).constructor(ProcessingStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<AppSpecification> APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppSpecification").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::appSpecification)).setter(CreateProcessingJobRequest.setter(Builder::appSpecification)).constructor(AppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSpecification").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::environment)).setter(CreateProcessingJobRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::networkConfig)).setter(CreateProcessingJobRequest.setter(Builder::networkConfig)).constructor(NetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::roleArn)).setter(CreateProcessingJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::tags)).setter(CreateProcessingJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentConfig").getter(CreateProcessingJobRequest.getter(CreateProcessingJobRequest::experimentConfig)).setter(CreateProcessingJobRequest.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_INPUTS_FIELD, PROCESSING_OUTPUT_CONFIG_FIELD, PROCESSING_JOB_NAME_FIELD, PROCESSING_RESOURCES_FIELD, STOPPING_CONDITION_FIELD, APP_SPECIFICATION_FIELD, ENVIRONMENT_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, EXPERIMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProcessingInputs", PROCESSING_INPUTS_FIELD);
            this.put("ProcessingOutputConfig", PROCESSING_OUTPUT_CONFIG_FIELD);
            this.put("ProcessingJobName", PROCESSING_JOB_NAME_FIELD);
            this.put("ProcessingResources", PROCESSING_RESOURCES_FIELD);
            this.put("StoppingCondition", STOPPING_CONDITION_FIELD);
            this.put("AppSpecification", APP_SPECIFICATION_FIELD);
            this.put("Environment", ENVIRONMENT_FIELD);
            this.put("NetworkConfig", NETWORK_CONFIG_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ExperimentConfig", EXPERIMENT_CONFIG_FIELD);
        }
    });
    private final List<ProcessingInput> processingInputs;
    private final ProcessingOutputConfig processingOutputConfig;
    private final String processingJobName;
    private final ProcessingResources processingResources;
    private final ProcessingStoppingCondition stoppingCondition;
    private final AppSpecification appSpecification;
    private final Map<String, String> environment;
    private final NetworkConfig networkConfig;
    private final String roleArn;
    private final List<Tag> tags;
    private final ExperimentConfig experimentConfig;

    private CreateProcessingJobRequest(BuilderImpl builder) {
        super(builder);
        this.processingInputs = builder.processingInputs;
        this.processingOutputConfig = builder.processingOutputConfig;
        this.processingJobName = builder.processingJobName;
        this.processingResources = builder.processingResources;
        this.stoppingCondition = builder.stoppingCondition;
        this.appSpecification = builder.appSpecification;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.experimentConfig = builder.experimentConfig;
    }

    public final boolean hasProcessingInputs() {
        return this.processingInputs != null && !(this.processingInputs instanceof SdkAutoConstructList);
    }

    public final List<ProcessingInput> processingInputs() {
        return this.processingInputs;
    }

    public final ProcessingOutputConfig processingOutputConfig() {
        return this.processingOutputConfig;
    }

    public final String processingJobName() {
        return this.processingJobName;
    }

    public final ProcessingResources processingResources() {
        return this.processingResources;
    }

    public final ProcessingStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final AppSpecification appSpecification() {
        return this.appSpecification;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final NetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessingInputs() ? this.processingInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.processingOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.appSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProcessingJobRequest)) {
            return false;
        }
        CreateProcessingJobRequest other = (CreateProcessingJobRequest)((Object)obj);
        return this.hasProcessingInputs() == other.hasProcessingInputs() && Objects.equals(this.processingInputs(), other.processingInputs()) && Objects.equals(this.processingOutputConfig(), other.processingOutputConfig()) && Objects.equals(this.processingJobName(), other.processingJobName()) && Objects.equals(this.processingResources(), other.processingResources()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.appSpecification(), other.appSpecification()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.experimentConfig(), other.experimentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProcessingJobRequest").add("ProcessingInputs", this.hasProcessingInputs() ? this.processingInputs() : null).add("ProcessingOutputConfig", (Object)this.processingOutputConfig()).add("ProcessingJobName", (Object)this.processingJobName()).add("ProcessingResources", (Object)this.processingResources()).add("StoppingCondition", (Object)this.stoppingCondition()).add("AppSpecification", (Object)this.appSpecification()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ExperimentConfig", (Object)this.experimentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessingInputs": {
                return Optional.ofNullable(clazz.cast(this.processingInputs()));
            }
            case "ProcessingOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.processingOutputConfig()));
            }
            case "ProcessingJobName": {
                return Optional.ofNullable(clazz.cast(this.processingJobName()));
            }
            case "ProcessingResources": {
                return Optional.ofNullable(clazz.cast(this.processingResources()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "AppSpecification": {
                return Optional.ofNullable(clazz.cast(this.appSpecification()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateProcessingJobRequest, T> g) {
        return obj -> g.apply((CreateProcessingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private List<ProcessingInput> processingInputs = DefaultSdkAutoConstructList.getInstance();
        private ProcessingOutputConfig processingOutputConfig;
        private String processingJobName;
        private ProcessingResources processingResources;
        private ProcessingStoppingCondition stoppingCondition;
        private AppSpecification appSpecification;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private NetworkConfig networkConfig;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProcessingJobRequest model) {
            super(model);
            this.processingInputs(model.processingInputs);
            this.processingOutputConfig(model.processingOutputConfig);
            this.processingJobName(model.processingJobName);
            this.processingResources(model.processingResources);
            this.stoppingCondition(model.stoppingCondition);
            this.appSpecification(model.appSpecification);
            this.environment(model.environment);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.experimentConfig(model.experimentConfig);
        }

        public final List<ProcessingInput.Builder> getProcessingInputs() {
            List<ProcessingInput.Builder> result = ProcessingInputsCopier.copyToBuilder(this.processingInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessingInputs(Collection<ProcessingInput.BuilderImpl> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copyFromBuilder(processingInputs);
        }

        @Override
        public final Builder processingInputs(Collection<ProcessingInput> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copy(processingInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(ProcessingInput ... processingInputs) {
            this.processingInputs(Arrays.asList(processingInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(Consumer<ProcessingInput.Builder> ... processingInputs) {
            this.processingInputs(Stream.of(processingInputs).map(c -> (ProcessingInput)((ProcessingInput.Builder)ProcessingInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProcessingOutputConfig.Builder getProcessingOutputConfig() {
            return this.processingOutputConfig != null ? this.processingOutputConfig.toBuilder() : null;
        }

        public final void setProcessingOutputConfig(ProcessingOutputConfig.BuilderImpl processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig != null ? processingOutputConfig.build() : null;
        }

        @Override
        public final Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        public final String getProcessingJobName() {
            return this.processingJobName;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final ProcessingResources.Builder getProcessingResources() {
            return this.processingResources != null ? this.processingResources.toBuilder() : null;
        }

        public final void setProcessingResources(ProcessingResources.BuilderImpl processingResources) {
            this.processingResources = processingResources != null ? processingResources.build() : null;
        }

        @Override
        public final Builder processingResources(ProcessingResources processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        public final ProcessingStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(ProcessingStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final AppSpecification.Builder getAppSpecification() {
            return this.appSpecification != null ? this.appSpecification.toBuilder() : null;
        }

        public final void setAppSpecification(AppSpecification.BuilderImpl appSpecification) {
            this.appSpecification = appSpecification != null ? appSpecification.build() : null;
        }

        @Override
        public final Builder appSpecification(AppSpecification appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProcessingJobRequest build() {
            return new CreateProcessingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProcessingJobRequest> {
        public Builder processingInputs(Collection<ProcessingInput> var1);

        public Builder processingInputs(ProcessingInput ... var1);

        public Builder processingInputs(Consumer<ProcessingInput.Builder> ... var1);

        public Builder processingOutputConfig(ProcessingOutputConfig var1);

        default public Builder processingOutputConfig(Consumer<ProcessingOutputConfig.Builder> processingOutputConfig) {
            return this.processingOutputConfig((ProcessingOutputConfig)((ProcessingOutputConfig.Builder)ProcessingOutputConfig.builder().applyMutation(processingOutputConfig)).build());
        }

        public Builder processingJobName(String var1);

        public Builder processingResources(ProcessingResources var1);

        default public Builder processingResources(Consumer<ProcessingResources.Builder> processingResources) {
            return this.processingResources((ProcessingResources)((ProcessingResources.Builder)ProcessingResources.builder().applyMutation(processingResources)).build());
        }

        public Builder stoppingCondition(ProcessingStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<ProcessingStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((ProcessingStoppingCondition)((ProcessingStoppingCondition.Builder)ProcessingStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder appSpecification(AppSpecification var1);

        default public Builder appSpecification(Consumer<AppSpecification.Builder> appSpecification) {
            return this.appSpecification((AppSpecification)((AppSpecification.Builder)AppSpecification.builder().applyMutation(appSpecification)).build());
        }

        public Builder environment(Map<String, String> var1);

        public Builder networkConfig(NetworkConfig var1);

        default public Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return this.networkConfig((NetworkConfig)((NetworkConfig.Builder)NetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

