/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJsonDatasetFormat;
import software.amazon.awssdk.services.sagemaker.model.MonitoringParquetDatasetFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringDatasetFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringDatasetFormat> {
    private static final SdkField<MonitoringCsvDatasetFormat> CSV_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Csv").getter(MonitoringDatasetFormat.getter(MonitoringDatasetFormat::csv)).setter(MonitoringDatasetFormat.setter(Builder::csv)).constructor(MonitoringCsvDatasetFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csv").build()}).build();
    private static final SdkField<MonitoringJsonDatasetFormat> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Json").getter(MonitoringDatasetFormat.getter(MonitoringDatasetFormat::json)).setter(MonitoringDatasetFormat.setter(Builder::json)).constructor(MonitoringJsonDatasetFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Json").build()}).build();
    private static final SdkField<MonitoringParquetDatasetFormat> PARQUET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parquet").getter(MonitoringDatasetFormat.getter(MonitoringDatasetFormat::parquet)).setter(MonitoringDatasetFormat.setter(Builder::parquet)).constructor(MonitoringParquetDatasetFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parquet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD, JSON_FIELD, PARQUET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Csv", CSV_FIELD);
            this.put("Json", JSON_FIELD);
            this.put("Parquet", PARQUET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MonitoringCsvDatasetFormat csv;
    private final MonitoringJsonDatasetFormat json;
    private final MonitoringParquetDatasetFormat parquet;

    private MonitoringDatasetFormat(BuilderImpl builder) {
        this.csv = builder.csv;
        this.json = builder.json;
        this.parquet = builder.parquet;
    }

    public final MonitoringCsvDatasetFormat csv() {
        return this.csv;
    }

    public final MonitoringJsonDatasetFormat json() {
        return this.json;
    }

    public final MonitoringParquetDatasetFormat parquet() {
        return this.parquet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csv());
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringDatasetFormat)) {
            return false;
        }
        MonitoringDatasetFormat other = (MonitoringDatasetFormat)obj;
        return Objects.equals(this.csv(), other.csv()) && Objects.equals(this.json(), other.json()) && Objects.equals(this.parquet(), other.parquet());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringDatasetFormat").add("Csv", (Object)this.csv()).add("Json", (Object)this.json()).add("Parquet", (Object)this.parquet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Csv": {
                return Optional.ofNullable(clazz.cast(this.csv()));
            }
            case "Json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
            case "Parquet": {
                return Optional.ofNullable(clazz.cast(this.parquet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringDatasetFormat, T> g) {
        return obj -> g.apply((MonitoringDatasetFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonitoringCsvDatasetFormat csv;
        private MonitoringJsonDatasetFormat json;
        private MonitoringParquetDatasetFormat parquet;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringDatasetFormat model) {
            this.csv(model.csv);
            this.json(model.json);
            this.parquet(model.parquet);
        }

        public final MonitoringCsvDatasetFormat.Builder getCsv() {
            return this.csv != null ? this.csv.toBuilder() : null;
        }

        public final void setCsv(MonitoringCsvDatasetFormat.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(MonitoringCsvDatasetFormat csv) {
            this.csv = csv;
            return this;
        }

        public final MonitoringJsonDatasetFormat.Builder getJson() {
            return this.json != null ? this.json.toBuilder() : null;
        }

        public final void setJson(MonitoringJsonDatasetFormat.BuilderImpl json) {
            this.json = json != null ? json.build() : null;
        }

        @Override
        public final Builder json(MonitoringJsonDatasetFormat json) {
            this.json = json;
            return this;
        }

        public final MonitoringParquetDatasetFormat.Builder getParquet() {
            return this.parquet != null ? this.parquet.toBuilder() : null;
        }

        public final void setParquet(MonitoringParquetDatasetFormat.BuilderImpl parquet) {
            this.parquet = parquet != null ? parquet.build() : null;
        }

        @Override
        public final Builder parquet(MonitoringParquetDatasetFormat parquet) {
            this.parquet = parquet;
            return this;
        }

        public MonitoringDatasetFormat build() {
            return new MonitoringDatasetFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringDatasetFormat> {
        public Builder csv(MonitoringCsvDatasetFormat var1);

        default public Builder csv(Consumer<MonitoringCsvDatasetFormat.Builder> csv) {
            return this.csv((MonitoringCsvDatasetFormat)((MonitoringCsvDatasetFormat.Builder)MonitoringCsvDatasetFormat.builder().applyMutation(csv)).build());
        }

        public Builder json(MonitoringJsonDatasetFormat var1);

        default public Builder json(Consumer<MonitoringJsonDatasetFormat.Builder> json) {
            return this.json((MonitoringJsonDatasetFormat)((MonitoringJsonDatasetFormat.Builder)MonitoringJsonDatasetFormat.builder().applyMutation(json)).build());
        }

        public Builder parquet(MonitoringParquetDatasetFormat var1);

        default public Builder parquet(Consumer<MonitoringParquetDatasetFormat.Builder> parquet) {
            return this.parquet((MonitoringParquetDatasetFormat)((MonitoringParquetDatasetFormat.Builder)MonitoringParquetDatasetFormat.builder().applyMutation(parquet)).build());
        }
    }
}

