/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelCardSecurityConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelCardStatus;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelCard> {
    private static final SdkField<String> MODEL_CARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardArn").getter(ModelCard.getter(ModelCard::modelCardArn)).setter(ModelCard.setter(Builder::modelCardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardArn").build()}).build();
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardName").getter(ModelCard.getter(ModelCard::modelCardName)).setter(ModelCard.setter(Builder::modelCardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()}).build();
    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelCardVersion").getter(ModelCard.getter(ModelCard::modelCardVersion)).setter(ModelCard.setter(Builder::modelCardVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ModelCard.getter(ModelCard::content)).setter(ModelCard.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardStatus").getter(ModelCard.getter(ModelCard::modelCardStatusAsString)).setter(ModelCard.setter(Builder::modelCardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()}).build();
    private static final SdkField<ModelCardSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(ModelCard.getter(ModelCard::securityConfig)).setter(ModelCard.setter(Builder::securityConfig)).constructor(ModelCardSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ModelCard.getter(ModelCard::creationTime)).setter(ModelCard.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(ModelCard.getter(ModelCard::createdBy)).setter(ModelCard.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ModelCard.getter(ModelCard::lastModifiedTime)).setter(ModelCard.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(ModelCard.getter(ModelCard::lastModifiedBy)).setter(ModelCard.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ModelCard.getter(ModelCard::tags)).setter(ModelCard.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelId").getter(ModelCard.getter(ModelCard::modelId)).setter(ModelCard.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelId").build()}).build();
    private static final SdkField<String> RISK_RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RiskRating").getter(ModelCard.getter(ModelCard::riskRating)).setter(ModelCard.setter(Builder::riskRating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskRating").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(ModelCard.getter(ModelCard::modelPackageGroupName)).setter(ModelCard.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_ARN_FIELD, MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, CONTENT_FIELD, MODEL_CARD_STATUS_FIELD, SECURITY_CONFIG_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, TAGS_FIELD, MODEL_ID_FIELD, RISK_RATING_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelCardArn", MODEL_CARD_ARN_FIELD);
            this.put("ModelCardName", MODEL_CARD_NAME_FIELD);
            this.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
            this.put("Content", CONTENT_FIELD);
            this.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
            this.put("SecurityConfig", SECURITY_CONFIG_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ModelId", MODEL_ID_FIELD);
            this.put("RiskRating", RISK_RATING_FIELD);
            this.put("ModelPackageGroupName", MODEL_PACKAGE_GROUP_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelCardArn;
    private final String modelCardName;
    private final Integer modelCardVersion;
    private final String content;
    private final String modelCardStatus;
    private final ModelCardSecurityConfig securityConfig;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final List<Tag> tags;
    private final String modelId;
    private final String riskRating;
    private final String modelPackageGroupName;

    private ModelCard(BuilderImpl builder) {
        this.modelCardArn = builder.modelCardArn;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.content = builder.content;
        this.modelCardStatus = builder.modelCardStatus;
        this.securityConfig = builder.securityConfig;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.tags = builder.tags;
        this.modelId = builder.modelId;
        this.riskRating = builder.riskRating;
        this.modelPackageGroupName = builder.modelPackageGroupName;
    }

    public final String modelCardArn() {
        return this.modelCardArn;
    }

    public final String modelCardName() {
        return this.modelCardName;
    }

    public final Integer modelCardVersion() {
        return this.modelCardVersion;
    }

    public final String content() {
        return this.content;
    }

    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(this.modelCardStatus);
    }

    public final String modelCardStatusAsString() {
        return this.modelCardStatus;
    }

    public final ModelCardSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String riskRating() {
        return this.riskRating;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskRating());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCard)) {
            return false;
        }
        ModelCard other = (ModelCard)obj;
        return Objects.equals(this.modelCardArn(), other.modelCardArn()) && Objects.equals(this.modelCardName(), other.modelCardName()) && Objects.equals(this.modelCardVersion(), other.modelCardVersion()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.modelCardStatusAsString(), other.modelCardStatusAsString()) && Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.riskRating(), other.riskRating()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"ModelCard").add("ModelCardArn", (Object)this.modelCardArn()).add("ModelCardName", (Object)this.modelCardName()).add("ModelCardVersion", (Object)this.modelCardVersion()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelCardStatus", (Object)this.modelCardStatusAsString()).add("SecurityConfig", (Object)this.securityConfig()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Tags", this.hasTags() ? this.tags() : null).add("ModelId", (Object)this.modelId()).add("RiskRating", (Object)this.riskRating()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardArn": {
                return Optional.ofNullable(clazz.cast(this.modelCardArn()));
            }
            case "ModelCardName": {
                return Optional.ofNullable(clazz.cast(this.modelCardName()));
            }
            case "ModelCardVersion": {
                return Optional.ofNullable(clazz.cast(this.modelCardVersion()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ModelCardStatus": {
                return Optional.ofNullable(clazz.cast(this.modelCardStatusAsString()));
            }
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ModelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "RiskRating": {
                return Optional.ofNullable(clazz.cast(this.riskRating()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelCard, T> g) {
        return obj -> g.apply((ModelCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelCardArn;
        private String modelCardName;
        private Integer modelCardVersion;
        private String content;
        private String modelCardStatus;
        private ModelCardSecurityConfig securityConfig;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String modelId;
        private String riskRating;
        private String modelPackageGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCard model) {
            this.modelCardArn(model.modelCardArn);
            this.modelCardName(model.modelCardName);
            this.modelCardVersion(model.modelCardVersion);
            this.content(model.content);
            this.modelCardStatus(model.modelCardStatus);
            this.securityConfig(model.securityConfig);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.tags(model.tags);
            this.modelId(model.modelId);
            this.riskRating(model.riskRating);
            this.modelPackageGroupName(model.modelPackageGroupName);
        }

        public final String getModelCardArn() {
            return this.modelCardArn;
        }

        public final void setModelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
        }

        @Override
        public final Builder modelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
            return this;
        }

        public final String getModelCardName() {
            return this.modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return this.modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getModelCardStatus() {
            return this.modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final ModelCardSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(ModelCardSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(ModelCardSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getRiskRating() {
            return this.riskRating;
        }

        public final void setRiskRating(String riskRating) {
            this.riskRating = riskRating;
        }

        @Override
        public final Builder riskRating(String riskRating) {
            this.riskRating = riskRating;
            return this;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public ModelCard build() {
            return new ModelCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelCard> {
        public Builder modelCardArn(String var1);

        public Builder modelCardName(String var1);

        public Builder modelCardVersion(Integer var1);

        public Builder content(String var1);

        public Builder modelCardStatus(String var1);

        public Builder modelCardStatus(ModelCardStatus var1);

        public Builder securityConfig(ModelCardSecurityConfig var1);

        default public Builder securityConfig(Consumer<ModelCardSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((ModelCardSecurityConfig)((ModelCardSecurityConfig.Builder)ModelCardSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder modelId(String var1);

        public Builder riskRating(String var1);

        public Builder modelPackageGroupName(String var1);
    }
}

