/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelCardSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelCardSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCardsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelCardsResponse> {
    private static final SdkField<List<ModelCardSummary>> MODEL_CARD_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelCardSummaries").getter(ListModelCardsResponse.getter(ListModelCardsResponse::modelCardSummaries)).setter(ListModelCardsResponse.setter(Builder::modelCardSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelCardSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelCardsResponse.getter(ListModelCardsResponse::nextToken)).setter(ListModelCardsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelCardSummaries", MODEL_CARD_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ModelCardSummary> modelCardSummaries;
    private final String nextToken;

    private ListModelCardsResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardSummaries = builder.modelCardSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelCardSummaries() {
        return this.modelCardSummaries != null && !(this.modelCardSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelCardSummary> modelCardSummaries() {
        return this.modelCardSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelCardSummaries() ? this.modelCardSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardsResponse)) {
            return false;
        }
        ListModelCardsResponse other = (ListModelCardsResponse)((Object)obj);
        return this.hasModelCardSummaries() == other.hasModelCardSummaries() && Objects.equals(this.modelCardSummaries(), other.modelCardSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCardsResponse").add("ModelCardSummaries", this.hasModelCardSummaries() ? this.modelCardSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelCardSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardsResponse, T> g) {
        return obj -> g.apply((ListModelCardsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelCardSummary> modelCardSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardsResponse model) {
            super(model);
            this.modelCardSummaries(model.modelCardSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ModelCardSummary.Builder> getModelCardSummaries() {
            List<ModelCardSummary.Builder> result = ModelCardSummaryListCopier.copyToBuilder(this.modelCardSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCardSummaries(Collection<ModelCardSummary.BuilderImpl> modelCardSummaries) {
            this.modelCardSummaries = ModelCardSummaryListCopier.copyFromBuilder(modelCardSummaries);
        }

        @Override
        public final Builder modelCardSummaries(Collection<ModelCardSummary> modelCardSummaries) {
            this.modelCardSummaries = ModelCardSummaryListCopier.copy(modelCardSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardSummaries(ModelCardSummary ... modelCardSummaries) {
            this.modelCardSummaries(Arrays.asList(modelCardSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardSummaries(Consumer<ModelCardSummary.Builder> ... modelCardSummaries) {
            this.modelCardSummaries(Stream.of(modelCardSummaries).map(c -> (ModelCardSummary)((ModelCardSummary.Builder)ModelCardSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelCardsResponse build() {
            return new ListModelCardsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCardsResponse> {
        public Builder modelCardSummaries(Collection<ModelCardSummary> var1);

        public Builder modelCardSummaries(ModelCardSummary ... var1);

        public Builder modelCardSummaries(Consumer<ModelCardSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

