/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig;
import software.amazon.awssdk.services.sagemaker.model.ClarifyShapConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyExplainerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyExplainerConfig> {
    private static final SdkField<String> ENABLE_EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnableExplanations").getter(ClarifyExplainerConfig.getter(ClarifyExplainerConfig::enableExplanations)).setter(ClarifyExplainerConfig.setter(Builder::enableExplanations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableExplanations").build()}).build();
    private static final SdkField<ClarifyInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceConfig").getter(ClarifyExplainerConfig.getter(ClarifyExplainerConfig::inferenceConfig)).setter(ClarifyExplainerConfig.setter(Builder::inferenceConfig)).constructor(ClarifyInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceConfig").build()}).build();
    private static final SdkField<ClarifyShapConfig> SHAP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShapConfig").getter(ClarifyExplainerConfig.getter(ClarifyExplainerConfig::shapConfig)).setter(ClarifyExplainerConfig.setter(Builder::shapConfig)).constructor(ClarifyShapConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_EXPLANATIONS_FIELD, INFERENCE_CONFIG_FIELD, SHAP_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EnableExplanations", ENABLE_EXPLANATIONS_FIELD);
            this.put("InferenceConfig", INFERENCE_CONFIG_FIELD);
            this.put("ShapConfig", SHAP_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String enableExplanations;
    private final ClarifyInferenceConfig inferenceConfig;
    private final ClarifyShapConfig shapConfig;

    private ClarifyExplainerConfig(BuilderImpl builder) {
        this.enableExplanations = builder.enableExplanations;
        this.inferenceConfig = builder.inferenceConfig;
        this.shapConfig = builder.shapConfig;
    }

    public final String enableExplanations() {
        return this.enableExplanations;
    }

    public final ClarifyInferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final ClarifyShapConfig shapConfig() {
        return this.shapConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExplanations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyExplainerConfig)) {
            return false;
        }
        ClarifyExplainerConfig other = (ClarifyExplainerConfig)obj;
        return Objects.equals(this.enableExplanations(), other.enableExplanations()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.shapConfig(), other.shapConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyExplainerConfig").add("EnableExplanations", (Object)this.enableExplanations()).add("InferenceConfig", (Object)this.inferenceConfig()).add("ShapConfig", (Object)this.shapConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableExplanations": {
                return Optional.ofNullable(clazz.cast(this.enableExplanations()));
            }
            case "InferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "ShapConfig": {
                return Optional.ofNullable(clazz.cast(this.shapConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyExplainerConfig, T> g) {
        return obj -> g.apply((ClarifyExplainerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String enableExplanations;
        private ClarifyInferenceConfig inferenceConfig;
        private ClarifyShapConfig shapConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyExplainerConfig model) {
            this.enableExplanations(model.enableExplanations);
            this.inferenceConfig(model.inferenceConfig);
            this.shapConfig(model.shapConfig);
        }

        public final String getEnableExplanations() {
            return this.enableExplanations;
        }

        public final void setEnableExplanations(String enableExplanations) {
            this.enableExplanations = enableExplanations;
        }

        @Override
        public final Builder enableExplanations(String enableExplanations) {
            this.enableExplanations = enableExplanations;
            return this;
        }

        public final ClarifyInferenceConfig.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(ClarifyInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(ClarifyInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final ClarifyShapConfig.Builder getShapConfig() {
            return this.shapConfig != null ? this.shapConfig.toBuilder() : null;
        }

        public final void setShapConfig(ClarifyShapConfig.BuilderImpl shapConfig) {
            this.shapConfig = shapConfig != null ? shapConfig.build() : null;
        }

        @Override
        public final Builder shapConfig(ClarifyShapConfig shapConfig) {
            this.shapConfig = shapConfig;
            return this;
        }

        public ClarifyExplainerConfig build() {
            return new ClarifyExplainerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyExplainerConfig> {
        public Builder enableExplanations(String var1);

        public Builder inferenceConfig(ClarifyInferenceConfig var1);

        default public Builder inferenceConfig(Consumer<ClarifyInferenceConfig.Builder> inferenceConfig) {
            return this.inferenceConfig((ClarifyInferenceConfig)((ClarifyInferenceConfig.Builder)ClarifyInferenceConfig.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder shapConfig(ClarifyShapConfig var1);

        default public Builder shapConfig(Consumer<ClarifyShapConfig.Builder> shapConfig) {
            return this.shapConfig((ClarifyShapConfig)((ClarifyShapConfig.Builder)ClarifyShapConfig.builder().applyMutation(shapConfig)).build());
        }
    }
}

