/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataMapCopier;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelMetrics;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SkipModelValidation;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageName)).setter(CreateModelPackageRequest.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageGroupName)).setter(CreateModelPackageRequest.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageDescription").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelPackageDescription)).setter(CreateModelPackageRequest.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::inferenceSpecification)).setter(CreateModelPackageRequest.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::validationSpecification)).setter(CreateModelPackageRequest.setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAlgorithmSpecification").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::sourceAlgorithmSpecification)).setter(CreateModelPackageRequest.setter(Builder::sourceAlgorithmSpecification)).constructor(SourceAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::certifyForMarketplace)).setter(CreateModelPackageRequest.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::tags)).setter(CreateModelPackageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelApprovalStatusAsString)).setter(CreateModelPackageRequest.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::metadataProperties)).setter(CreateModelPackageRequest.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<ModelMetrics> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelMetrics").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::modelMetrics)).setter(CreateModelPackageRequest.setter(Builder::modelMetrics)).constructor(ModelMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::clientToken)).setter(CreateModelPackageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::domain)).setter(CreateModelPackageRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Task").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::task)).setter(CreateModelPackageRequest.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamplePayloadUrl").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::samplePayloadUrl)).setter(CreateModelPackageRequest.setter(Builder::samplePayloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomerMetadataProperties").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::customerMetadataProperties)).setter(CreateModelPackageRequest.setter(Builder::customerMetadataProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DriftCheckBaselines> DRIFT_CHECK_BASELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DriftCheckBaselines").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::driftCheckBaselines)).setter(CreateModelPackageRequest.setter(Builder::driftCheckBaselines)).constructor(DriftCheckBaselines::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftCheckBaselines").build()}).build();
    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalInferenceSpecifications").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::additionalInferenceSpecifications)).setter(CreateModelPackageRequest.setter(Builder::additionalInferenceSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInferenceSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalInferenceSpecificationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SKIP_MODEL_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkipModelValidation").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::skipModelValidationAsString)).setter(CreateModelPackageRequest.setter(Builder::skipModelValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipModelValidation").build()}).build();
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUri").getter(CreateModelPackageRequest.getter(CreateModelPackageRequest::sourceUri)).setter(CreateModelPackageRequest.setter(Builder::sourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, SOURCE_ALGORITHM_SPECIFICATION_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, TAGS_FIELD, MODEL_APPROVAL_STATUS_FIELD, METADATA_PROPERTIES_FIELD, MODEL_METRICS_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_FIELD, TASK_FIELD, SAMPLE_PAYLOAD_URL_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD, DRIFT_CHECK_BASELINES_FIELD, ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD, SKIP_MODEL_VALIDATION_FIELD, SOURCE_URI_FIELD));
    private final String modelPackageName;
    private final String modelPackageGroupName;
    private final String modelPackageDescription;
    private final InferenceSpecification inferenceSpecification;
    private final ModelPackageValidationSpecification validationSpecification;
    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;
    private final Boolean certifyForMarketplace;
    private final List<Tag> tags;
    private final String modelApprovalStatus;
    private final MetadataProperties metadataProperties;
    private final ModelMetrics modelMetrics;
    private final String clientToken;
    private final String domain;
    private final String task;
    private final String samplePayloadUrl;
    private final Map<String, String> customerMetadataProperties;
    private final DriftCheckBaselines driftCheckBaselines;
    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications;
    private final String skipModelValidation;
    private final String sourceUri;

    private CreateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.tags = builder.tags;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.metadataProperties = builder.metadataProperties;
        this.modelMetrics = builder.modelMetrics;
        this.clientToken = builder.clientToken;
        this.domain = builder.domain;
        this.task = builder.task;
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.driftCheckBaselines = builder.driftCheckBaselines;
        this.additionalInferenceSpecifications = builder.additionalInferenceSpecifications;
        this.skipModelValidation = builder.skipModelValidation;
        this.sourceUri = builder.sourceUri;
    }

    public final String modelPackageName() {
        return this.modelPackageName;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final ModelPackageValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public final SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return this.sourceAlgorithmSpecification;
    }

    public final Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final ModelMetrics modelMetrics() {
        return this.modelMetrics;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domain() {
        return this.domain;
    }

    public final String task() {
        return this.task;
    }

    public final String samplePayloadUrl() {
        return this.samplePayloadUrl;
    }

    public final boolean hasCustomerMetadataProperties() {
        return this.customerMetadataProperties != null && !(this.customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customerMetadataProperties() {
        return this.customerMetadataProperties;
    }

    public final DriftCheckBaselines driftCheckBaselines() {
        return this.driftCheckBaselines;
    }

    public final boolean hasAdditionalInferenceSpecifications() {
        return this.additionalInferenceSpecifications != null && !(this.additionalInferenceSpecifications instanceof SdkAutoConstructList);
    }

    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications() {
        return this.additionalInferenceSpecifications;
    }

    public final SkipModelValidation skipModelValidation() {
        return SkipModelValidation.fromValue(this.skipModelValidation);
    }

    public final String skipModelValidationAsString() {
        return this.skipModelValidation;
    }

    public final String sourceUri() {
        return this.sourceUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePayloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.driftCheckBaselines());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInferenceSpecifications() ? this.additionalInferenceSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.skipModelValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelPackageRequest)) {
            return false;
        }
        CreateModelPackageRequest other = (CreateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && Objects.equals(this.modelMetrics(), other.modelMetrics()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.samplePayloadUrl(), other.samplePayloadUrl()) && this.hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties() && Objects.equals(this.customerMetadataProperties(), other.customerMetadataProperties()) && Objects.equals(this.driftCheckBaselines(), other.driftCheckBaselines()) && this.hasAdditionalInferenceSpecifications() == other.hasAdditionalInferenceSpecifications() && Objects.equals(this.additionalInferenceSpecifications(), other.additionalInferenceSpecifications()) && Objects.equals(this.skipModelValidationAsString(), other.skipModelValidationAsString()) && Objects.equals(this.sourceUri(), other.sourceUri());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelPackageRequest").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("SourceAlgorithmSpecification", (Object)this.sourceAlgorithmSpecification()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).add("Tags", this.hasTags() ? this.tags() : null).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("MetadataProperties", (Object)this.metadataProperties()).add("ModelMetrics", (Object)this.modelMetrics()).add("ClientToken", (Object)this.clientToken()).add("Domain", (Object)this.domain()).add("Task", (Object)this.task()).add("SamplePayloadUrl", (Object)this.samplePayloadUrl()).add("CustomerMetadataProperties", this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null).add("DriftCheckBaselines", (Object)this.driftCheckBaselines()).add("AdditionalInferenceSpecifications", this.hasAdditionalInferenceSpecifications() ? this.additionalInferenceSpecifications() : null).add("SkipModelValidation", (Object)this.skipModelValidationAsString()).add("SourceUri", (Object)this.sourceUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "SourceAlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithmSpecification()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "SamplePayloadUrl": {
                return Optional.ofNullable(clazz.cast(this.samplePayloadUrl()));
            }
            case "CustomerMetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataProperties()));
            }
            case "DriftCheckBaselines": {
                return Optional.ofNullable(clazz.cast(this.driftCheckBaselines()));
            }
            case "AdditionalInferenceSpecifications": {
                return Optional.ofNullable(clazz.cast(this.additionalInferenceSpecifications()));
            }
            case "SkipModelValidation": {
                return Optional.ofNullable(clazz.cast(this.skipModelValidationAsString()));
            }
            case "SourceUri": {
                return Optional.ofNullable(clazz.cast(this.sourceUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelPackageRequest, T> g) {
        return obj -> g.apply((CreateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageGroupName;
        private String modelPackageDescription;
        private InferenceSpecification inferenceSpecification;
        private ModelPackageValidationSpecification validationSpecification;
        private SourceAlgorithmSpecification sourceAlgorithmSpecification;
        private Boolean certifyForMarketplace;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String modelApprovalStatus;
        private MetadataProperties metadataProperties;
        private ModelMetrics modelMetrics;
        private String clientToken;
        private String domain;
        private String task;
        private String samplePayloadUrl;
        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();
        private DriftCheckBaselines driftCheckBaselines;
        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String skipModelValidation;
        private String sourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelPackageRequest model) {
            super(model);
            this.modelPackageName(model.modelPackageName);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageDescription(model.modelPackageDescription);
            this.inferenceSpecification(model.inferenceSpecification);
            this.validationSpecification(model.validationSpecification);
            this.sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            this.certifyForMarketplace(model.certifyForMarketplace);
            this.tags(model.tags);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.metadataProperties(model.metadataProperties);
            this.modelMetrics(model.modelMetrics);
            this.clientToken(model.clientToken);
            this.domain(model.domain);
            this.task(model.task);
            this.samplePayloadUrl(model.samplePayloadUrl);
            this.customerMetadataProperties(model.customerMetadataProperties);
            this.driftCheckBaselines(model.driftCheckBaselines);
            this.additionalInferenceSpecifications(model.additionalInferenceSpecifications);
            this.skipModelValidation(model.skipModelValidation);
            this.sourceUri(model.sourceUri);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.toBuilder() : null;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final ModelMetrics.Builder getModelMetrics() {
            return this.modelMetrics != null ? this.modelMetrics.toBuilder() : null;
        }

        public final void setModelMetrics(ModelMetrics.BuilderImpl modelMetrics) {
            this.modelMetrics = modelMetrics != null ? modelMetrics.build() : null;
        }

        @Override
        public final Builder modelMetrics(ModelMetrics modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getSamplePayloadUrl() {
            return this.samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (this.customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final DriftCheckBaselines.Builder getDriftCheckBaselines() {
            return this.driftCheckBaselines != null ? this.driftCheckBaselines.toBuilder() : null;
        }

        public final void setDriftCheckBaselines(DriftCheckBaselines.BuilderImpl driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines != null ? driftCheckBaselines.build() : null;
        }

        @Override
        public final Builder driftCheckBaselines(DriftCheckBaselines driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines;
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecifications() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier.copyToBuilder(this.additionalInferenceSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier.copyFromBuilder(additionalInferenceSpecifications);
        }

        @Override
        public final Builder additionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier.copy(additionalInferenceSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(AdditionalInferenceSpecificationDefinition ... additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications(Arrays.asList(additionalInferenceSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications(Stream.of(additionalInferenceSpecifications).map(c -> (AdditionalInferenceSpecificationDefinition)((AdditionalInferenceSpecificationDefinition.Builder)AdditionalInferenceSpecificationDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSkipModelValidation() {
            return this.skipModelValidation;
        }

        public final void setSkipModelValidation(String skipModelValidation) {
            this.skipModelValidation = skipModelValidation;
        }

        @Override
        public final Builder skipModelValidation(String skipModelValidation) {
            this.skipModelValidation = skipModelValidation;
            return this;
        }

        @Override
        public final Builder skipModelValidation(SkipModelValidation skipModelValidation) {
            this.skipModelValidation(skipModelValidation == null ? null : skipModelValidation.toString());
            return this;
        }

        public final String getSourceUri() {
            return this.sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelPackageRequest build() {
            return new CreateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelPackageRequest> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder validationSpecification(ModelPackageValidationSpecification var1);

        default public Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((ModelPackageValidationSpecification)((ModelPackageValidationSpecification.Builder)ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification var1);

        default public Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return this.sourceAlgorithmSpecification((SourceAlgorithmSpecification)((SourceAlgorithmSpecification.Builder)SourceAlgorithmSpecification.builder().applyMutation(sourceAlgorithmSpecification)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder modelMetrics(ModelMetrics var1);

        default public Builder modelMetrics(Consumer<ModelMetrics.Builder> modelMetrics) {
            return this.modelMetrics((ModelMetrics)((ModelMetrics.Builder)ModelMetrics.builder().applyMutation(modelMetrics)).build());
        }

        public Builder clientToken(String var1);

        public Builder domain(String var1);

        public Builder task(String var1);

        public Builder samplePayloadUrl(String var1);

        public Builder customerMetadataProperties(Map<String, String> var1);

        public Builder driftCheckBaselines(DriftCheckBaselines var1);

        default public Builder driftCheckBaselines(Consumer<DriftCheckBaselines.Builder> driftCheckBaselines) {
            return this.driftCheckBaselines((DriftCheckBaselines)((DriftCheckBaselines.Builder)DriftCheckBaselines.builder().applyMutation(driftCheckBaselines)).build());
        }

        public Builder additionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition> var1);

        public Builder additionalInferenceSpecifications(AdditionalInferenceSpecificationDefinition ... var1);

        public Builder additionalInferenceSpecifications(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... var1);

        public Builder skipModelValidation(String var1);

        public Builder skipModelValidation(SkipModelValidation var1);

        public Builder sourceUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

