/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig;
import software.amazon.awssdk.services.sagemaker.model.HubSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHubRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateHubRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(CreateHubRequest.getter(CreateHubRequest::hubName)).setter(CreateHubRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDescription").getter(CreateHubRequest.getter(CreateHubRequest::hubDescription)).setter(CreateHubRequest.setter(Builder::hubDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()}).build();
    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDisplayName").getter(CreateHubRequest.getter(CreateHubRequest::hubDisplayName)).setter(CreateHubRequest.setter(Builder::hubDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()}).build();
    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubSearchKeywords").getter(CreateHubRequest.getter(CreateHubRequest::hubSearchKeywords)).setter(CreateHubRequest.setter(Builder::hubSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HubS3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3StorageConfig").getter(CreateHubRequest.getter(CreateHubRequest::s3StorageConfig)).setter(CreateHubRequest.setter(Builder::s3StorageConfig)).constructor(HubS3StorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateHubRequest.getter(CreateHubRequest::tags)).setter(CreateHubRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_SEARCH_KEYWORDS_FIELD, S3_STORAGE_CONFIG_FIELD, TAGS_FIELD));
    private final String hubName;
    private final String hubDescription;
    private final String hubDisplayName;
    private final List<String> hubSearchKeywords;
    private final HubS3StorageConfig s3StorageConfig;
    private final List<Tag> tags;

    private CreateHubRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubDescription = builder.hubDescription;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.s3StorageConfig = builder.s3StorageConfig;
        this.tags = builder.tags;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubDescription() {
        return this.hubDescription;
    }

    public final String hubDisplayName() {
        return this.hubDisplayName;
    }

    public final boolean hasHubSearchKeywords() {
        return this.hubSearchKeywords != null && !(this.hubSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubSearchKeywords() {
        return this.hubSearchKeywords;
    }

    public final HubS3StorageConfig s3StorageConfig() {
        return this.s3StorageConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubRequest)) {
            return false;
        }
        CreateHubRequest other = (CreateHubRequest)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubDescription(), other.hubDescription()) && Objects.equals(this.hubDisplayName(), other.hubDisplayName()) && this.hasHubSearchKeywords() == other.hasHubSearchKeywords() && Objects.equals(this.hubSearchKeywords(), other.hubSearchKeywords()) && Objects.equals(this.s3StorageConfig(), other.s3StorageConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHubRequest").add("HubName", (Object)this.hubName()).add("HubDescription", (Object)this.hubDescription()).add("HubDisplayName", (Object)this.hubDisplayName()).add("HubSearchKeywords", this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null).add("S3StorageConfig", (Object)this.s3StorageConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubDescription": {
                return Optional.ofNullable(clazz.cast(this.hubDescription()));
            }
            case "HubDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubDisplayName()));
            }
            case "HubSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubSearchKeywords()));
            }
            case "S3StorageConfig": {
                return Optional.ofNullable(clazz.cast(this.s3StorageConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHubRequest, T> g) {
        return obj -> g.apply((CreateHubRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubName;
        private String hubDescription;
        private String hubDisplayName;
        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private HubS3StorageConfig s3StorageConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubRequest model) {
            super(model);
            this.hubName(model.hubName);
            this.hubDescription(model.hubDescription);
            this.hubDisplayName(model.hubDisplayName);
            this.hubSearchKeywords(model.hubSearchKeywords);
            this.s3StorageConfig(model.s3StorageConfig);
            this.tags(model.tags);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubDescription() {
            return this.hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final String getHubDisplayName() {
            return this.hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (this.hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String ... hubSearchKeywords) {
            this.hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final HubS3StorageConfig.Builder getS3StorageConfig() {
            return this.s3StorageConfig != null ? this.s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(HubS3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        public final Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHubRequest build() {
            return new CreateHubRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHubRequest> {
        public Builder hubName(String var1);

        public Builder hubDescription(String var1);

        public Builder hubDisplayName(String var1);

        public Builder hubSearchKeywords(Collection<String> var1);

        public Builder hubSearchKeywords(String ... var1);

        public Builder s3StorageConfig(HubS3StorageConfig var1);

        default public Builder s3StorageConfig(Consumer<HubS3StorageConfig.Builder> s3StorageConfig) {
            return this.s3StorageConfig((HubS3StorageConfig)((HubS3StorageConfig.Builder)HubS3StorageConfig.builder().applyMutation(s3StorageConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

