/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialSummary;

public class ListTrialsPublisher
implements SdkPublisher<ListTrialsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTrialsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrialsPublisher(SageMakerAsyncClient client, ListTrialsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrialsPublisher(SageMakerAsyncClient client, ListTrialsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrialsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrialsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrialSummary> trialSummaries() {
        Function<ListTrialsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trialSummaries() != null) {
                return response.trialSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrialsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrialsResponseFetcher
    implements AsyncPageFetcher<ListTrialsResponse> {
        private ListTrialsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrialsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrialsResponse> nextPage(ListTrialsResponse previousPage) {
            if (previousPage == null) {
                return ListTrialsPublisher.this.client.listTrials(ListTrialsPublisher.this.firstRequest);
            }
            return ListTrialsPublisher.this.client.listTrials((ListTrialsRequest)((Object)ListTrialsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

