/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutModelPackageGroupPolicyRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, PutModelPackageGroupPolicyRequest> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(PutModelPackageGroupPolicyRequest.getter(PutModelPackageGroupPolicyRequest::modelPackageGroupName)).setter(PutModelPackageGroupPolicyRequest.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePolicy").getter(PutModelPackageGroupPolicyRequest.getter(PutModelPackageGroupPolicyRequest::resourcePolicy)).setter(PutModelPackageGroupPolicyRequest.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_GROUP_NAME_FIELD, RESOURCE_POLICY_FIELD));
    private final String modelPackageGroupName;
    private final String resourcePolicy;

    private PutModelPackageGroupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.resourcePolicy = builder.resourcePolicy;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final String resourcePolicy() {
        return this.resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutModelPackageGroupPolicyRequest)) {
            return false;
        }
        PutModelPackageGroupPolicyRequest other = (PutModelPackageGroupPolicyRequest)((Object)obj);
        return Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutModelPackageGroupPolicyRequest").add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ResourcePolicy", (Object)this.resourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutModelPackageGroupPolicyRequest, T> g) {
        return obj -> g.apply((PutModelPackageGroupPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageGroupName;
        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutModelPackageGroupPolicyRequest model) {
            super(model);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.resourcePolicy(model.resourcePolicy);
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutModelPackageGroupPolicyRequest build() {
            return new PutModelPackageGroupPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutModelPackageGroupPolicyRequest> {
        public Builder modelPackageGroupName(String var1);

        public Builder resourcePolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

