/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;

public class ListAutoMLJobsIterable
implements SdkIterable<ListAutoMlJobsResponse> {
    private final SageMakerClient client;
    private final ListAutoMlJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutoMLJobsIterable(SageMakerClient client, ListAutoMlJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutoMlJobsResponseFetcher();
    }

    public Iterator<ListAutoMlJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutoMLJobSummary> autoMLJobSummaries() {
        Function<ListAutoMlJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoMLJobSummaries() != null) {
                return response.autoMLJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutoMlJobsResponseFetcher
    implements SyncPageFetcher<ListAutoMlJobsResponse> {
        private ListAutoMlJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutoMlJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutoMlJobsResponse nextPage(ListAutoMlJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAutoMLJobsIterable.this.client.listAutoMLJobs(ListAutoMLJobsIterable.this.firstRequest);
            }
            return ListAutoMLJobsIterable.this.client.listAutoMLJobs((ListAutoMlJobsRequest)((Object)ListAutoMLJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

