/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollingUpdatePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<RollingUpdatePolicy.Builder, RollingUpdatePolicy> {
    private static final SdkField<CapacitySize> MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<CapacitySize> builder(MarshallingType.SDK_POJO).memberName("MaximumBatchSize")
            .getter(getter(RollingUpdatePolicy::maximumBatchSize)).setter(setter(Builder::maximumBatchSize))
            .constructor(CapacitySize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()).build();

    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitIntervalInSeconds").getter(getter(RollingUpdatePolicy::waitIntervalInSeconds))
            .setter(setter(Builder::waitIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumExecutionTimeoutInSeconds")
            .getter(getter(RollingUpdatePolicy::maximumExecutionTimeoutInSeconds))
            .setter(setter(Builder::maximumExecutionTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<CapacitySize> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField
            .<CapacitySize> builder(MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize")
            .getter(getter(RollingUpdatePolicy::rollbackMaximumBatchSize)).setter(setter(Builder::rollbackMaximumBatchSize))
            .constructor(CapacitySize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD,
            WAIT_INTERVAL_IN_SECONDS_FIELD, MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD, ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CapacitySize maximumBatchSize;

    private final Integer waitIntervalInSeconds;

    private final Integer maximumExecutionTimeoutInSeconds;

    private final CapacitySize rollbackMaximumBatchSize;

    private RollingUpdatePolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    /**
     * Returns the value of the MaximumBatchSize property for this object.
     * 
     * @return The value of the MaximumBatchSize property for this object.
     */
    public final CapacitySize maximumBatchSize() {
        return maximumBatchSize;
    }

    /**
     * <p>
     * The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
     * </p>
     * 
     * @return The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
     */
    public final Integer waitIntervalInSeconds() {
        return waitIntervalInSeconds;
    }

    /**
     * <p>
     * The time limit for the total deployment. Exceeding this limit causes a timeout.
     * </p>
     * 
     * @return The time limit for the total deployment. Exceeding this limit causes a timeout.
     */
    public final Integer maximumExecutionTimeoutInSeconds() {
        return maximumExecutionTimeoutInSeconds;
    }

    /**
     * Returns the value of the RollbackMaximumBatchSize property for this object.
     * 
     * @return The value of the RollbackMaximumBatchSize property for this object.
     */
    public final CapacitySize rollbackMaximumBatchSize() {
        return rollbackMaximumBatchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumExecutionTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackMaximumBatchSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollingUpdatePolicy)) {
            return false;
        }
        RollingUpdatePolicy other = (RollingUpdatePolicy) obj;
        return Objects.equals(maximumBatchSize(), other.maximumBatchSize())
                && Objects.equals(waitIntervalInSeconds(), other.waitIntervalInSeconds())
                && Objects.equals(maximumExecutionTimeoutInSeconds(), other.maximumExecutionTimeoutInSeconds())
                && Objects.equals(rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollingUpdatePolicy").add("MaximumBatchSize", maximumBatchSize())
                .add("WaitIntervalInSeconds", waitIntervalInSeconds())
                .add("MaximumExecutionTimeoutInSeconds", maximumExecutionTimeoutInSeconds())
                .add("RollbackMaximumBatchSize", rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumBatchSize":
            return Optional.ofNullable(clazz.cast(maximumBatchSize()));
        case "WaitIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(waitIntervalInSeconds()));
        case "MaximumExecutionTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(maximumExecutionTimeoutInSeconds()));
        case "RollbackMaximumBatchSize":
            return Optional.ofNullable(clazz.cast(rollbackMaximumBatchSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RollingUpdatePolicy, T> g) {
        return obj -> g.apply((RollingUpdatePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RollingUpdatePolicy> {
        /**
         * Sets the value of the MaximumBatchSize property for this object.
         *
         * @param maximumBatchSize
         *        The new value for the MaximumBatchSize property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchSize(CapacitySize maximumBatchSize);

        /**
         * Sets the value of the MaximumBatchSize property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CapacitySize.Builder} avoiding the need
         * to create one manually via {@link CapacitySize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySize.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumBatchSize(CapacitySize)}.
         * 
         * @param maximumBatchSize
         *        a consumer that will call methods on {@link CapacitySize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumBatchSize(CapacitySize)
         */
        default Builder maximumBatchSize(Consumer<CapacitySize.Builder> maximumBatchSize) {
            return maximumBatchSize(CapacitySize.builder().applyMutation(maximumBatchSize).build());
        }

        /**
         * <p>
         * The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
         * </p>
         * 
         * @param waitIntervalInSeconds
         *        The length of the baking period, during which SageMaker monitors alarms for each batch on the new
         *        fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitIntervalInSeconds(Integer waitIntervalInSeconds);

        /**
         * <p>
         * The time limit for the total deployment. Exceeding this limit causes a timeout.
         * </p>
         * 
         * @param maximumExecutionTimeoutInSeconds
         *        The time limit for the total deployment. Exceeding this limit causes a timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds);

        /**
         * Sets the value of the RollbackMaximumBatchSize property for this object.
         *
         * @param rollbackMaximumBatchSize
         *        The new value for the RollbackMaximumBatchSize property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackMaximumBatchSize(CapacitySize rollbackMaximumBatchSize);

        /**
         * Sets the value of the RollbackMaximumBatchSize property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CapacitySize.Builder} avoiding the need
         * to create one manually via {@link CapacitySize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySize.Builder#build()} is called immediately and its
         * result is passed to {@link #rollbackMaximumBatchSize(CapacitySize)}.
         * 
         * @param rollbackMaximumBatchSize
         *        a consumer that will call methods on {@link CapacitySize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackMaximumBatchSize(CapacitySize)
         */
        default Builder rollbackMaximumBatchSize(Consumer<CapacitySize.Builder> rollbackMaximumBatchSize) {
            return rollbackMaximumBatchSize(CapacitySize.builder().applyMutation(rollbackMaximumBatchSize).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CapacitySize maximumBatchSize;

        private Integer waitIntervalInSeconds;

        private Integer maximumExecutionTimeoutInSeconds;

        private CapacitySize rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(RollingUpdatePolicy model) {
            maximumBatchSize(model.maximumBatchSize);
            waitIntervalInSeconds(model.waitIntervalInSeconds);
            maximumExecutionTimeoutInSeconds(model.maximumExecutionTimeoutInSeconds);
            rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final CapacitySize.Builder getMaximumBatchSize() {
            return maximumBatchSize != null ? maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(CapacitySize.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(CapacitySize maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final Integer getMaximumExecutionTimeoutInSeconds() {
            return maximumExecutionTimeoutInSeconds;
        }

        public final void setMaximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
        }

        @Override
        public final Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
            return this;
        }

        public final CapacitySize.Builder getRollbackMaximumBatchSize() {
            return rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(CapacitySize.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(CapacitySize rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        @Override
        public RollingUpdatePolicy build() {
            return new RollingUpdatePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
