/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringAlertSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringAlertSummary> {
    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringAlertName").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::monitoringAlertName)).setter(MonitoringAlertSummary.setter(Builder::monitoringAlertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::creationTime)).setter(MonitoringAlertSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::lastModifiedTime)).setter(MonitoringAlertSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertStatus").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::alertStatusAsString)).setter(MonitoringAlertSummary.setter(Builder::alertStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlert").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::datapointsToAlert)).setter(MonitoringAlertSummary.setter(Builder::datapointsToAlert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlert").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriod").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::evaluationPeriod)).setter(MonitoringAlertSummary.setter(Builder::evaluationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriod").build()}).build();
    private static final SdkField<MonitoringAlertActions> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(MonitoringAlertSummary.getter(MonitoringAlertSummary::actions)).setter(MonitoringAlertSummary.setter(Builder::actions)).constructor(MonitoringAlertActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_ALERT_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ALERT_STATUS_FIELD, DATAPOINTS_TO_ALERT_FIELD, EVALUATION_PERIOD_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitoringAlertName;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String alertStatus;
    private final Integer datapointsToAlert;
    private final Integer evaluationPeriod;
    private final MonitoringAlertActions actions;

    private MonitoringAlertSummary(BuilderImpl builder) {
        this.monitoringAlertName = builder.monitoringAlertName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.alertStatus = builder.alertStatus;
        this.datapointsToAlert = builder.datapointsToAlert;
        this.evaluationPeriod = builder.evaluationPeriod;
        this.actions = builder.actions;
    }

    public final String monitoringAlertName() {
        return this.monitoringAlertName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final MonitoringAlertStatus alertStatus() {
        return MonitoringAlertStatus.fromValue(this.alertStatus);
    }

    public final String alertStatusAsString() {
        return this.alertStatus;
    }

    public final Integer datapointsToAlert() {
        return this.datapointsToAlert;
    }

    public final Integer evaluationPeriod() {
        return this.evaluationPeriod;
    }

    public final MonitoringAlertActions actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlert());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAlertSummary)) {
            return false;
        }
        MonitoringAlertSummary other = (MonitoringAlertSummary)obj;
        return Objects.equals(this.monitoringAlertName(), other.monitoringAlertName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.alertStatusAsString(), other.alertStatusAsString()) && Objects.equals(this.datapointsToAlert(), other.datapointsToAlert()) && Objects.equals(this.evaluationPeriod(), other.evaluationPeriod()) && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringAlertSummary").add("MonitoringAlertName", (Object)this.monitoringAlertName()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("AlertStatus", (Object)this.alertStatusAsString()).add("DatapointsToAlert", (Object)this.datapointsToAlert()).add("EvaluationPeriod", (Object)this.evaluationPeriod()).add("Actions", (Object)this.actions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringAlertName": {
                return Optional.ofNullable(clazz.cast(this.monitoringAlertName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "AlertStatus": {
                return Optional.ofNullable(clazz.cast(this.alertStatusAsString()));
            }
            case "DatapointsToAlert": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlert()));
            }
            case "EvaluationPeriod": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriod()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAlertSummary, T> g) {
        return obj -> g.apply((MonitoringAlertSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoringAlertName;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String alertStatus;
        private Integer datapointsToAlert;
        private Integer evaluationPeriod;
        private MonitoringAlertActions actions;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAlertSummary model) {
            this.monitoringAlertName(model.monitoringAlertName);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.alertStatus(model.alertStatus);
            this.datapointsToAlert(model.datapointsToAlert);
            this.evaluationPeriod(model.evaluationPeriod);
            this.actions(model.actions);
        }

        public final String getMonitoringAlertName() {
            return this.monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getAlertStatus() {
            return this.alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(MonitoringAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final Integer getDatapointsToAlert() {
            return this.datapointsToAlert;
        }

        public final void setDatapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
        }

        @Override
        public final Builder datapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
            return this;
        }

        public final Integer getEvaluationPeriod() {
            return this.evaluationPeriod;
        }

        public final void setEvaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
        }

        @Override
        public final Builder evaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
            return this;
        }

        public final MonitoringAlertActions.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        public final void setActions(MonitoringAlertActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MonitoringAlertActions actions) {
            this.actions = actions;
            return this;
        }

        public MonitoringAlertSummary build() {
            return new MonitoringAlertSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringAlertSummary> {
        public Builder monitoringAlertName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder alertStatus(String var1);

        public Builder alertStatus(MonitoringAlertStatus var1);

        public Builder datapointsToAlert(Integer var1);

        public Builder evaluationPeriod(Integer var1);

        public Builder actions(MonitoringAlertActions var1);

        default public Builder actions(Consumer<MonitoringAlertActions.Builder> actions) {
            return this.actions((MonitoringAlertActions)((MonitoringAlertActions.Builder)MonitoringAlertActions.builder().applyMutation(actions)).build());
        }
    }
}

