/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse;
import software.amazon.awssdk.services.sagemaker.model.SpaceDetails;

public class ListSpacesIterable
implements SdkIterable<ListSpacesResponse> {
    private final SageMakerClient client;
    private final ListSpacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpacesIterable(SageMakerClient client, ListSpacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSpacesResponseFetcher();
    }

    public Iterator<ListSpacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpaceDetails> spaces() {
        Function<ListSpacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.spaces() != null) {
                return response.spaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSpacesResponseFetcher
    implements SyncPageFetcher<ListSpacesResponse> {
        private ListSpacesResponseFetcher() {
        }

        public boolean hasNextPage(ListSpacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpacesResponse nextPage(ListSpacesResponse previousPage) {
            if (previousPage == null) {
                return ListSpacesIterable.this.client.listSpaces(ListSpacesIterable.this.firstRequest);
            }
            return ListSpacesIterable.this.client.listSpaces((ListSpacesRequest)((Object)ListSpacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

