/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;

public class ListFeatureGroupsPublisher
implements SdkPublisher<ListFeatureGroupsResponse> {
    private final SageMakerAsyncClient client;
    private final ListFeatureGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFeatureGroupsPublisher(SageMakerAsyncClient client, ListFeatureGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFeatureGroupsPublisher(SageMakerAsyncClient client, ListFeatureGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFeatureGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFeatureGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FeatureGroupSummary> featureGroupSummaries() {
        Function<ListFeatureGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.featureGroupSummaries() != null) {
                return response.featureGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFeatureGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFeatureGroupsResponseFetcher
    implements AsyncPageFetcher<ListFeatureGroupsResponse> {
        private ListFeatureGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListFeatureGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFeatureGroupsResponse> nextPage(ListFeatureGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListFeatureGroupsPublisher.this.client.listFeatureGroups(ListFeatureGroupsPublisher.this.firstRequest);
            }
            return ListFeatureGroupsPublisher.this.client.listFeatureGroups((ListFeatureGroupsRequest)((Object)ListFeatureGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

