/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeviceSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.DeviceSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListDevicesResponse> {
    private static final SdkField<List<DeviceSummary>> DEVICE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceSummaries").getter(ListDevicesResponse.getter(ListDevicesResponse::deviceSummaries)).setter(ListDevicesResponse.setter(Builder::deviceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicesResponse.getter(ListDevicesResponse::nextToken)).setter(ListDevicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DeviceSummary> deviceSummaries;
    private final String nextToken;

    private ListDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceSummaries = builder.deviceSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeviceSummaries() {
        return this.deviceSummaries != null && !(this.deviceSummaries instanceof SdkAutoConstructList);
    }

    public final List<DeviceSummary> deviceSummaries() {
        return this.deviceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceSummaries() ? this.deviceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResponse)) {
            return false;
        }
        ListDevicesResponse other = (ListDevicesResponse)((Object)obj);
        return this.hasDeviceSummaries() == other.hasDeviceSummaries() && Objects.equals(this.deviceSummaries(), other.deviceSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesResponse").add("DeviceSummaries", this.hasDeviceSummaries() ? this.deviceSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceSummaries": {
                return Optional.ofNullable(clazz.cast(this.deviceSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesResponse, T> g) {
        return obj -> g.apply((ListDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<DeviceSummary> deviceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesResponse model) {
            super(model);
            this.deviceSummaries(model.deviceSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DeviceSummary.Builder> getDeviceSummaries() {
            List<DeviceSummary.Builder> result = DeviceSummariesCopier.copyToBuilder(this.deviceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder deviceSummaries(Collection<DeviceSummary> deviceSummaries) {
            this.deviceSummaries = DeviceSummariesCopier.copy(deviceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceSummaries(DeviceSummary ... deviceSummaries) {
            this.deviceSummaries(Arrays.asList(deviceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceSummaries(Consumer<DeviceSummary.Builder> ... deviceSummaries) {
            this.deviceSummaries(Stream.of(deviceSummaries).map(c -> (DeviceSummary)((DeviceSummary.Builder)DeviceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceSummaries(Collection<DeviceSummary.BuilderImpl> deviceSummaries) {
            this.deviceSummaries = DeviceSummariesCopier.copyFromBuilder(deviceSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevicesResponse build() {
            return new ListDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesResponse> {
        public Builder deviceSummaries(Collection<DeviceSummary> var1);

        public Builder deviceSummaries(DeviceSummary ... var1);

        public Builder deviceSummaries(Consumer<DeviceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

