/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointInputConfiguration> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(EndpointInputConfiguration.getter(EndpointInputConfiguration::instanceTypeAsString)).setter(EndpointInputConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> INFERENCE_SPECIFICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSpecificationName").getter(EndpointInputConfiguration.getter(EndpointInputConfiguration::inferenceSpecificationName)).setter(EndpointInputConfiguration.setter(Builder::inferenceSpecificationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecificationName").build()}).build();
    private static final SdkField<EnvironmentParameterRanges> ENVIRONMENT_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentParameterRanges").getter(EndpointInputConfiguration.getter(EndpointInputConfiguration::environmentParameterRanges)).setter(EndpointInputConfiguration.setter(Builder::environmentParameterRanges)).constructor(EnvironmentParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentParameterRanges").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INFERENCE_SPECIFICATION_NAME_FIELD, ENVIRONMENT_PARAMETER_RANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String inferenceSpecificationName;
    private final EnvironmentParameterRanges environmentParameterRanges;

    private EndpointInputConfiguration(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.inferenceSpecificationName = builder.inferenceSpecificationName;
        this.environmentParameterRanges = builder.environmentParameterRanges;
    }

    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String inferenceSpecificationName() {
        return this.inferenceSpecificationName;
    }

    public final EnvironmentParameterRanges environmentParameterRanges() {
        return this.environmentParameterRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecificationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentParameterRanges());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointInputConfiguration)) {
            return false;
        }
        EndpointInputConfiguration other = (EndpointInputConfiguration)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.inferenceSpecificationName(), other.inferenceSpecificationName()) && Objects.equals(this.environmentParameterRanges(), other.environmentParameterRanges());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointInputConfiguration").add("InstanceType", (Object)this.instanceTypeAsString()).add("InferenceSpecificationName", (Object)this.inferenceSpecificationName()).add("EnvironmentParameterRanges", (Object)this.environmentParameterRanges()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InferenceSpecificationName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecificationName()));
            }
            case "EnvironmentParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.environmentParameterRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointInputConfiguration, T> g) {
        return obj -> g.apply((EndpointInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String inferenceSpecificationName;
        private EnvironmentParameterRanges environmentParameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointInputConfiguration model) {
            this.instanceType(model.instanceType);
            this.inferenceSpecificationName(model.inferenceSpecificationName);
            this.environmentParameterRanges(model.environmentParameterRanges);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInferenceSpecificationName() {
            return this.inferenceSpecificationName;
        }

        public final void setInferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
        }

        @Override
        public final Builder inferenceSpecificationName(String inferenceSpecificationName) {
            this.inferenceSpecificationName = inferenceSpecificationName;
            return this;
        }

        public final EnvironmentParameterRanges.Builder getEnvironmentParameterRanges() {
            return this.environmentParameterRanges != null ? this.environmentParameterRanges.toBuilder() : null;
        }

        public final void setEnvironmentParameterRanges(EnvironmentParameterRanges.BuilderImpl environmentParameterRanges) {
            this.environmentParameterRanges = environmentParameterRanges != null ? environmentParameterRanges.build() : null;
        }

        @Override
        public final Builder environmentParameterRanges(EnvironmentParameterRanges environmentParameterRanges) {
            this.environmentParameterRanges = environmentParameterRanges;
            return this;
        }

        public EndpointInputConfiguration build() {
            return new EndpointInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointInputConfiguration> {
        public Builder instanceType(String var1);

        public Builder instanceType(ProductionVariantInstanceType var1);

        public Builder inferenceSpecificationName(String var1);

        public Builder environmentParameterRanges(EnvironmentParameterRanges var1);

        default public Builder environmentParameterRanges(Consumer<EnvironmentParameterRanges.Builder> environmentParameterRanges) {
            return this.environmentParameterRanges((EnvironmentParameterRanges)((EnvironmentParameterRanges.Builder)EnvironmentParameterRanges.builder().applyMutation(environmentParameterRanges)).build());
        }
    }
}

