/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingJobSummary> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobName").getter(TrainingJobSummary.getter(TrainingJobSummary::trainingJobName)).setter(TrainingJobSummary.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobArn").getter(TrainingJobSummary.getter(TrainingJobSummary::trainingJobArn)).setter(TrainingJobSummary.setter(Builder::trainingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TrainingJobSummary.getter(TrainingJobSummary::creationTime)).setter(TrainingJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingEndTime").getter(TrainingJobSummary.getter(TrainingJobSummary::trainingEndTime)).setter(TrainingJobSummary.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TrainingJobSummary.getter(TrainingJobSummary::lastModifiedTime)).setter(TrainingJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobStatus").getter(TrainingJobSummary.getter(TrainingJobSummary::trainingJobStatusAsString)).setter(TrainingJobSummary.setter(Builder::trainingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, TRAINING_JOB_ARN_FIELD, CREATION_TIME_FIELD, TRAINING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRAINING_JOB_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingJobName;
    private final String trainingJobArn;
    private final Instant creationTime;
    private final Instant trainingEndTime;
    private final Instant lastModifiedTime;
    private final String trainingJobStatus;

    private TrainingJobSummary(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.creationTime = builder.creationTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatus = builder.trainingJobStatus;
    }

    public final String trainingJobName() {
        return this.trainingJobName;
    }

    public final String trainingJobArn() {
        return this.trainingJobArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public final String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobSummary)) {
            return false;
        }
        TrainingJobSummary other = (TrainingJobSummary)obj;
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingJobSummary").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("CreationTime", (Object)this.creationTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobSummary, T> g) {
        return obj -> g.apply((TrainingJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private Instant creationTime;
        private Instant trainingEndTime;
        private Instant lastModifiedTime;
        private String trainingJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobSummary model) {
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.creationTime(model.creationTime);
            this.trainingEndTime(model.trainingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trainingJobStatus(model.trainingJobStatus);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public TrainingJobSummary build() {
            return new TrainingJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingJobSummary> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);
    }
}

