/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureGroupSummary> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(FeatureGroupSummary.getter(FeatureGroupSummary::featureGroupName)).setter(FeatureGroupSummary.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupArn").getter(FeatureGroupSummary.getter(FeatureGroupSummary::featureGroupArn)).setter(FeatureGroupSummary.setter(Builder::featureGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FeatureGroupSummary.getter(FeatureGroupSummary::creationTime)).setter(FeatureGroupSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupStatus").getter(FeatureGroupSummary.getter(FeatureGroupSummary::featureGroupStatusAsString)).setter(FeatureGroupSummary.setter(Builder::featureGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatus").build()}).build();
    private static final SdkField<OfflineStoreStatus> OFFLINE_STORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreStatus").getter(FeatureGroupSummary.getter(FeatureGroupSummary::offlineStoreStatus)).setter(FeatureGroupSummary.setter(Builder::offlineStoreStatus)).constructor(OfflineStoreStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, FEATURE_GROUP_ARN_FIELD, CREATION_TIME_FIELD, FEATURE_GROUP_STATUS_FIELD, OFFLINE_STORE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featureGroupName;
    private final String featureGroupArn;
    private final Instant creationTime;
    private final String featureGroupStatus;
    private final OfflineStoreStatus offlineStoreStatus;

    private FeatureGroupSummary(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
        this.featureGroupArn = builder.featureGroupArn;
        this.creationTime = builder.creationTime;
        this.featureGroupStatus = builder.featureGroupStatus;
        this.offlineStoreStatus = builder.offlineStoreStatus;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String featureGroupArn() {
        return this.featureGroupArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final FeatureGroupStatus featureGroupStatus() {
        return FeatureGroupStatus.fromValue(this.featureGroupStatus);
    }

    public final String featureGroupStatusAsString() {
        return this.featureGroupStatus;
    }

    public final OfflineStoreStatus offlineStoreStatus() {
        return this.offlineStoreStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureGroupSummary)) {
            return false;
        }
        FeatureGroupSummary other = (FeatureGroupSummary)obj;
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.featureGroupArn(), other.featureGroupArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.featureGroupStatusAsString(), other.featureGroupStatusAsString()) && Objects.equals(this.offlineStoreStatus(), other.offlineStoreStatus());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureGroupSummary").add("FeatureGroupName", (Object)this.featureGroupName()).add("FeatureGroupArn", (Object)this.featureGroupArn()).add("CreationTime", (Object)this.creationTime()).add("FeatureGroupStatus", (Object)this.featureGroupStatusAsString()).add("OfflineStoreStatus", (Object)this.offlineStoreStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "FeatureGroupArn": {
                return Optional.ofNullable(clazz.cast(this.featureGroupArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FeatureGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.featureGroupStatusAsString()));
            }
            case "OfflineStoreStatus": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureGroupSummary, T> g) {
        return obj -> g.apply((FeatureGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String featureGroupArn;
        private Instant creationTime;
        private String featureGroupStatus;
        private OfflineStoreStatus offlineStoreStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureGroupSummary model) {
            this.featureGroupName(model.featureGroupName);
            this.featureGroupArn(model.featureGroupArn);
            this.creationTime(model.creationTime);
            this.featureGroupStatus(model.featureGroupStatus);
            this.offlineStoreStatus(model.offlineStoreStatus);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        @Transient
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureGroupArn() {
            return this.featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        @Transient
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFeatureGroupStatus() {
            return this.featureGroupStatus;
        }

        public final void setFeatureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
        }

        @Override
        @Transient
        public final Builder featureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus) {
            this.featureGroupStatus(featureGroupStatus == null ? null : featureGroupStatus.toString());
            return this;
        }

        public final OfflineStoreStatus.Builder getOfflineStoreStatus() {
            return this.offlineStoreStatus != null ? this.offlineStoreStatus.toBuilder() : null;
        }

        public final void setOfflineStoreStatus(OfflineStoreStatus.BuilderImpl offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus != null ? offlineStoreStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus;
            return this;
        }

        public FeatureGroupSummary build() {
            return new FeatureGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureGroupSummary> {
        public Builder featureGroupName(String var1);

        public Builder featureGroupArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder featureGroupStatus(String var1);

        public Builder featureGroupStatus(FeatureGroupStatus var1);

        public Builder offlineStoreStatus(OfflineStoreStatus var1);

        default public Builder offlineStoreStatus(Consumer<OfflineStoreStatus.Builder> offlineStoreStatus) {
            return this.offlineStoreStatus((OfflineStoreStatus)((OfflineStoreStatus.Builder)OfflineStoreStatus.builder().applyMutation(offlineStoreStatus)).build());
        }
    }
}

