/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatus;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureGroup> {
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupArn").getter(FeatureGroup.getter(FeatureGroup::featureGroupArn)).setter(FeatureGroup.setter(Builder::featureGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(FeatureGroup.getter(FeatureGroup::featureGroupName)).setter(FeatureGroup.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> RECORD_IDENTIFIER_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordIdentifierFeatureName").getter(FeatureGroup.getter(FeatureGroup::recordIdentifierFeatureName)).setter(FeatureGroup.setter(Builder::recordIdentifierFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierFeatureName").build()}).build();
    private static final SdkField<String> EVENT_TIME_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTimeFeatureName").getter(FeatureGroup.getter(FeatureGroup::eventTimeFeatureName)).setter(FeatureGroup.setter(Builder::eventTimeFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeFeatureName").build()}).build();
    private static final SdkField<List<FeatureDefinition>> FEATURE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureDefinitions").getter(FeatureGroup.getter(FeatureGroup::featureDefinitions)).setter(FeatureGroup.setter(Builder::featureDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FeatureGroup.getter(FeatureGroup::creationTime)).setter(FeatureGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<OnlineStoreConfig> ONLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnlineStoreConfig").getter(FeatureGroup.getter(FeatureGroup::onlineStoreConfig)).setter(FeatureGroup.setter(Builder::onlineStoreConfig)).constructor(OnlineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()}).build();
    private static final SdkField<OfflineStoreConfig> OFFLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreConfig").getter(FeatureGroup.getter(FeatureGroup::offlineStoreConfig)).setter(FeatureGroup.setter(Builder::offlineStoreConfig)).constructor(OfflineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(FeatureGroup.getter(FeatureGroup::roleArn)).setter(FeatureGroup.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupStatus").getter(FeatureGroup.getter(FeatureGroup::featureGroupStatusAsString)).setter(FeatureGroup.setter(Builder::featureGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatus").build()}).build();
    private static final SdkField<OfflineStoreStatus> OFFLINE_STORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreStatus").getter(FeatureGroup.getter(FeatureGroup::offlineStoreStatus)).setter(FeatureGroup.setter(Builder::offlineStoreStatus)).constructor(OfflineStoreStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(FeatureGroup.getter(FeatureGroup::failureReason)).setter(FeatureGroup.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FeatureGroup.getter(FeatureGroup::description)).setter(FeatureGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(FeatureGroup.getter(FeatureGroup::tags)).setter(FeatureGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_ARN_FIELD, FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_FEATURE_NAME_FIELD, EVENT_TIME_FEATURE_NAME_FIELD, FEATURE_DEFINITIONS_FIELD, CREATION_TIME_FIELD, ONLINE_STORE_CONFIG_FIELD, OFFLINE_STORE_CONFIG_FIELD, ROLE_ARN_FIELD, FEATURE_GROUP_STATUS_FIELD, OFFLINE_STORE_STATUS_FIELD, FAILURE_REASON_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featureGroupArn;
    private final String featureGroupName;
    private final String recordIdentifierFeatureName;
    private final String eventTimeFeatureName;
    private final List<FeatureDefinition> featureDefinitions;
    private final Instant creationTime;
    private final OnlineStoreConfig onlineStoreConfig;
    private final OfflineStoreConfig offlineStoreConfig;
    private final String roleArn;
    private final String featureGroupStatus;
    private final OfflineStoreStatus offlineStoreStatus;
    private final String failureReason;
    private final String description;
    private final List<Tag> tags;

    private FeatureGroup(BuilderImpl builder) {
        this.featureGroupArn = builder.featureGroupArn;
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierFeatureName = builder.recordIdentifierFeatureName;
        this.eventTimeFeatureName = builder.eventTimeFeatureName;
        this.featureDefinitions = builder.featureDefinitions;
        this.creationTime = builder.creationTime;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.offlineStoreConfig = builder.offlineStoreConfig;
        this.roleArn = builder.roleArn;
        this.featureGroupStatus = builder.featureGroupStatus;
        this.offlineStoreStatus = builder.offlineStoreStatus;
        this.failureReason = builder.failureReason;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String featureGroupArn() {
        return this.featureGroupArn;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String recordIdentifierFeatureName() {
        return this.recordIdentifierFeatureName;
    }

    public final String eventTimeFeatureName() {
        return this.eventTimeFeatureName;
    }

    public final boolean hasFeatureDefinitions() {
        return this.featureDefinitions != null && !(this.featureDefinitions instanceof SdkAutoConstructList);
    }

    public final List<FeatureDefinition> featureDefinitions() {
        return this.featureDefinitions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final OnlineStoreConfig onlineStoreConfig() {
        return this.onlineStoreConfig;
    }

    public final OfflineStoreConfig offlineStoreConfig() {
        return this.offlineStoreConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final FeatureGroupStatus featureGroupStatus() {
        return FeatureGroupStatus.fromValue(this.featureGroupStatus);
    }

    public final String featureGroupStatusAsString() {
        return this.featureGroupStatus;
    }

    public final OfflineStoreStatus offlineStoreStatus() {
        return this.offlineStoreStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIdentifierFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureDefinitions() ? this.featureDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureGroup)) {
            return false;
        }
        FeatureGroup other = (FeatureGroup)obj;
        return Objects.equals(this.featureGroupArn(), other.featureGroupArn()) && Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.recordIdentifierFeatureName(), other.recordIdentifierFeatureName()) && Objects.equals(this.eventTimeFeatureName(), other.eventTimeFeatureName()) && this.hasFeatureDefinitions() == other.hasFeatureDefinitions() && Objects.equals(this.featureDefinitions(), other.featureDefinitions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.onlineStoreConfig(), other.onlineStoreConfig()) && Objects.equals(this.offlineStoreConfig(), other.offlineStoreConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.featureGroupStatusAsString(), other.featureGroupStatusAsString()) && Objects.equals(this.offlineStoreStatus(), other.offlineStoreStatus()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureGroup").add("FeatureGroupArn", (Object)this.featureGroupArn()).add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifierFeatureName", (Object)this.recordIdentifierFeatureName()).add("EventTimeFeatureName", (Object)this.eventTimeFeatureName()).add("FeatureDefinitions", this.hasFeatureDefinitions() ? this.featureDefinitions() : null).add("CreationTime", (Object)this.creationTime()).add("OnlineStoreConfig", (Object)this.onlineStoreConfig()).add("OfflineStoreConfig", (Object)this.offlineStoreConfig()).add("RoleArn", (Object)this.roleArn()).add("FeatureGroupStatus", (Object)this.featureGroupStatusAsString()).add("OfflineStoreStatus", (Object)this.offlineStoreStatus()).add("FailureReason", (Object)this.failureReason()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupArn": {
                return Optional.ofNullable(clazz.cast(this.featureGroupArn()));
            }
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifierFeatureName": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifierFeatureName()));
            }
            case "EventTimeFeatureName": {
                return Optional.ofNullable(clazz.cast(this.eventTimeFeatureName()));
            }
            case "FeatureDefinitions": {
                return Optional.ofNullable(clazz.cast(this.featureDefinitions()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OnlineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.onlineStoreConfig()));
            }
            case "OfflineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "FeatureGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.featureGroupStatusAsString()));
            }
            case "OfflineStoreStatus": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreStatus()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureGroup, T> g) {
        return obj -> g.apply((FeatureGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureGroupArn;
        private String featureGroupName;
        private String recordIdentifierFeatureName;
        private String eventTimeFeatureName;
        private List<FeatureDefinition> featureDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private OnlineStoreConfig onlineStoreConfig;
        private OfflineStoreConfig offlineStoreConfig;
        private String roleArn;
        private String featureGroupStatus;
        private OfflineStoreStatus offlineStoreStatus;
        private String failureReason;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureGroup model) {
            this.featureGroupArn(model.featureGroupArn);
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifierFeatureName(model.recordIdentifierFeatureName);
            this.eventTimeFeatureName(model.eventTimeFeatureName);
            this.featureDefinitions(model.featureDefinitions);
            this.creationTime(model.creationTime);
            this.onlineStoreConfig(model.onlineStoreConfig);
            this.offlineStoreConfig(model.offlineStoreConfig);
            this.roleArn(model.roleArn);
            this.featureGroupStatus(model.featureGroupStatus);
            this.offlineStoreStatus(model.offlineStoreStatus);
            this.failureReason(model.failureReason);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getFeatureGroupArn() {
            return this.featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        public final String getRecordIdentifierFeatureName() {
            return this.recordIdentifierFeatureName;
        }

        @Override
        public final Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        public final void setRecordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
        }

        public final String getEventTimeFeatureName() {
            return this.eventTimeFeatureName;
        }

        @Override
        public final Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        public final void setEventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
        }

        public final List<FeatureDefinition.Builder> getFeatureDefinitions() {
            List<FeatureDefinition.Builder> result = FeatureDefinitionsCopier.copyToBuilder(this.featureDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copy(featureDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(FeatureDefinition ... featureDefinitions) {
            this.featureDefinitions(Arrays.asList(featureDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... featureDefinitions) {
            this.featureDefinitions(Stream.of(featureDefinitions).map(c -> (FeatureDefinition)((FeatureDefinition.Builder)FeatureDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFeatureDefinitions(Collection<FeatureDefinition.BuilderImpl> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copyFromBuilder(featureDefinitions);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final OnlineStoreConfig.Builder getOnlineStoreConfig() {
            return this.onlineStoreConfig != null ? this.onlineStoreConfig.toBuilder() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfig.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        public final OfflineStoreConfig.Builder getOfflineStoreConfig() {
            return this.offlineStoreConfig != null ? this.offlineStoreConfig.toBuilder() : null;
        }

        @Override
        public final Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        public final void setOfflineStoreConfig(OfflineStoreConfig.BuilderImpl offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig != null ? offlineStoreConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getFeatureGroupStatus() {
            return this.featureGroupStatus;
        }

        @Override
        public final Builder featureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
            return this;
        }

        @Override
        public final Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus) {
            this.featureGroupStatus(featureGroupStatus == null ? null : featureGroupStatus.toString());
            return this;
        }

        public final void setFeatureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
        }

        public final OfflineStoreStatus.Builder getOfflineStoreStatus() {
            return this.offlineStoreStatus != null ? this.offlineStoreStatus.toBuilder() : null;
        }

        @Override
        public final Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus;
            return this;
        }

        public final void setOfflineStoreStatus(OfflineStoreStatus.BuilderImpl offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus != null ? offlineStoreStatus.build() : null;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public FeatureGroup build() {
            return new FeatureGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureGroup> {
        public Builder featureGroupArn(String var1);

        public Builder featureGroupName(String var1);

        public Builder recordIdentifierFeatureName(String var1);

        public Builder eventTimeFeatureName(String var1);

        public Builder featureDefinitions(Collection<FeatureDefinition> var1);

        public Builder featureDefinitions(FeatureDefinition ... var1);

        public Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder onlineStoreConfig(OnlineStoreConfig var1);

        default public Builder onlineStoreConfig(Consumer<OnlineStoreConfig.Builder> onlineStoreConfig) {
            return this.onlineStoreConfig((OnlineStoreConfig)((OnlineStoreConfig.Builder)OnlineStoreConfig.builder().applyMutation(onlineStoreConfig)).build());
        }

        public Builder offlineStoreConfig(OfflineStoreConfig var1);

        default public Builder offlineStoreConfig(Consumer<OfflineStoreConfig.Builder> offlineStoreConfig) {
            return this.offlineStoreConfig((OfflineStoreConfig)((OfflineStoreConfig.Builder)OfflineStoreConfig.builder().applyMutation(offlineStoreConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder featureGroupStatus(String var1);

        public Builder featureGroupStatus(FeatureGroupStatus var1);

        public Builder offlineStoreStatus(OfflineStoreStatus var1);

        default public Builder offlineStoreStatus(Consumer<OfflineStoreStatus.Builder> offlineStoreStatus) {
            return this.offlineStoreStatus((OfflineStoreStatus)((OfflineStoreStatus.Builder)OfflineStoreStatus.builder().applyMutation(offlineStoreStatus)).build());
        }

        public Builder failureReason(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

