/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3DataDistribution {
    FULLY_REPLICATED("FullyReplicated"),
    SHARDED_BY_S3_KEY("ShardedByS3Key"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3DataDistribution(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3DataDistribution fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3DataDistribution.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3DataDistribution> knownValues() {
        return Stream.of(S3DataDistribution.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

