/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Parameter;
import software.amazon.awssdk.services.sagemaker.model.ParameterListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPipelineExecutionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, StartPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::pipelineName)).setter(StartPipelineExecutionRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDisplayName").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::pipelineExecutionDisplayName)).setter(StartPipelineExecutionRequest.setter(Builder::pipelineExecutionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName").build()}).build();
    private static final SdkField<List<Parameter>> PIPELINE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineParameters").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::pipelineParameters)).setter(StartPipelineExecutionRequest.setter(Builder::pipelineParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineExecutionDescription").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::pipelineExecutionDescription)).setter(StartPipelineExecutionRequest.setter(Builder::pipelineExecutionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::clientRequestToken)).setter(StartPipelineExecutionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_PARAMETERS_FIELD, PIPELINE_EXECUTION_DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String pipelineName;
    private final String pipelineExecutionDisplayName;
    private final List<Parameter> pipelineParameters;
    private final String pipelineExecutionDescription;
    private final String clientRequestToken;

    private StartPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineParameters = builder.pipelineParameters;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineExecutionDisplayName() {
        return this.pipelineExecutionDisplayName;
    }

    public final boolean hasPipelineParameters() {
        return this.pipelineParameters != null && !(this.pipelineParameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> pipelineParameters() {
        return this.pipelineParameters;
    }

    public final String pipelineExecutionDescription() {
        return this.pipelineExecutionDescription;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineParameters() ? this.pipelineParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName()) && this.hasPipelineParameters() == other.hasPipelineParameters() && Objects.equals(this.pipelineParameters(), other.pipelineParameters()) && Objects.equals(this.pipelineExecutionDescription(), other.pipelineExecutionDescription()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartPipelineExecutionRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineExecutionDisplayName", (Object)this.pipelineExecutionDisplayName()).add("PipelineParameters", this.hasPipelineParameters() ? this.pipelineParameters() : null).add("PipelineExecutionDescription", (Object)this.pipelineExecutionDescription()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineExecutionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDisplayName()));
            }
            case "PipelineParameters": {
                return Optional.ofNullable(clazz.cast(this.pipelineParameters()));
            }
            case "PipelineExecutionDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionDescription()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineExecutionRequest, T> g) {
        return obj -> g.apply((StartPipelineExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineExecutionDisplayName;
        private List<Parameter> pipelineParameters = DefaultSdkAutoConstructList.getInstance();
        private String pipelineExecutionDescription;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineExecutionRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            this.pipelineParameters(model.pipelineParameters);
            this.pipelineExecutionDescription(model.pipelineExecutionDescription);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineExecutionDisplayName() {
            return this.pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        public final Collection<Parameter.Builder> getPipelineParameters() {
            if (this.pipelineParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pipelineParameters != null ? (Collection)this.pipelineParameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineParameters(Collection<Parameter> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copy(pipelineParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Parameter ... pipelineParameters) {
            this.pipelineParameters(Arrays.asList(pipelineParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Consumer<Parameter.Builder> ... pipelineParameters) {
            this.pipelineParameters(Stream.of(pipelineParameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineParameters(Collection<Parameter.BuilderImpl> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copyFromBuilder(pipelineParameters);
        }

        public final String getPipelineExecutionDescription() {
            return this.pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineExecutionRequest build() {
            return new StartPipelineExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPipelineExecutionRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineExecutionDisplayName(String var1);

        public Builder pipelineParameters(Collection<Parameter> var1);

        public Builder pipelineParameters(Parameter ... var1);

        public Builder pipelineParameters(Consumer<Parameter.Builder> ... var1);

        public Builder pipelineExecutionDescription(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

