/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.MonitoringBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringInputsCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.NetworkConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringJobDefinition> {
    private static final SdkField<MonitoringBaselineConfig> BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaselineConfig").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::baselineConfig)).setter(MonitoringJobDefinition.setter(Builder::baselineConfig)).constructor(MonitoringBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineConfig").build()}).build();
    private static final SdkField<List<MonitoringInput>> MONITORING_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringInputs").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::monitoringInputs)).setter(MonitoringJobDefinition.setter(Builder::monitoringInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MonitoringOutputConfig> MONITORING_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringOutputConfig").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::monitoringOutputConfig)).setter(MonitoringJobDefinition.setter(Builder::monitoringOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> MONITORING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringResources").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::monitoringResources)).setter(MonitoringJobDefinition.setter(Builder::monitoringResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringResources").build()}).build();
    private static final SdkField<MonitoringAppSpecification> MONITORING_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringAppSpecification").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::monitoringAppSpecification)).setter(MonitoringJobDefinition.setter(Builder::monitoringAppSpecification)).constructor(MonitoringAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAppSpecification").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::stoppingCondition)).setter(MonitoringJobDefinition.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::environment)).setter(MonitoringJobDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::networkConfig)).setter(MonitoringJobDefinition.setter(Builder::networkConfig)).constructor(NetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(MonitoringJobDefinition.getter(MonitoringJobDefinition::roleArn)).setter(MonitoringJobDefinition.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_CONFIG_FIELD, MONITORING_INPUTS_FIELD, MONITORING_OUTPUT_CONFIG_FIELD, MONITORING_RESOURCES_FIELD, MONITORING_APP_SPECIFICATION_FIELD, STOPPING_CONDITION_FIELD, ENVIRONMENT_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final MonitoringBaselineConfig baselineConfig;
    private final List<MonitoringInput> monitoringInputs;
    private final MonitoringOutputConfig monitoringOutputConfig;
    private final MonitoringResources monitoringResources;
    private final MonitoringAppSpecification monitoringAppSpecification;
    private final MonitoringStoppingCondition stoppingCondition;
    private final Map<String, String> environment;
    private final NetworkConfig networkConfig;
    private final String roleArn;

    private MonitoringJobDefinition(BuilderImpl builder) {
        this.baselineConfig = builder.baselineConfig;
        this.monitoringInputs = builder.monitoringInputs;
        this.monitoringOutputConfig = builder.monitoringOutputConfig;
        this.monitoringResources = builder.monitoringResources;
        this.monitoringAppSpecification = builder.monitoringAppSpecification;
        this.stoppingCondition = builder.stoppingCondition;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
    }

    public final MonitoringBaselineConfig baselineConfig() {
        return this.baselineConfig;
    }

    public final boolean hasMonitoringInputs() {
        return this.monitoringInputs != null && !(this.monitoringInputs instanceof SdkAutoConstructList);
    }

    public final List<MonitoringInput> monitoringInputs() {
        return this.monitoringInputs;
    }

    public final MonitoringOutputConfig monitoringOutputConfig() {
        return this.monitoringOutputConfig;
    }

    public final MonitoringResources monitoringResources() {
        return this.monitoringResources;
    }

    public final MonitoringAppSpecification monitoringAppSpecification() {
        return this.monitoringAppSpecification;
    }

    public final MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final NetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringInputs() ? this.monitoringInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringJobDefinition)) {
            return false;
        }
        MonitoringJobDefinition other = (MonitoringJobDefinition)obj;
        return Objects.equals(this.baselineConfig(), other.baselineConfig()) && this.hasMonitoringInputs() == other.hasMonitoringInputs() && Objects.equals(this.monitoringInputs(), other.monitoringInputs()) && Objects.equals(this.monitoringOutputConfig(), other.monitoringOutputConfig()) && Objects.equals(this.monitoringResources(), other.monitoringResources()) && Objects.equals(this.monitoringAppSpecification(), other.monitoringAppSpecification()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringJobDefinition").add("BaselineConfig", (Object)this.baselineConfig()).add("MonitoringInputs", this.hasMonitoringInputs() ? this.monitoringInputs() : null).add("MonitoringOutputConfig", (Object)this.monitoringOutputConfig()).add("MonitoringResources", (Object)this.monitoringResources()).add("MonitoringAppSpecification", (Object)this.monitoringAppSpecification()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.baselineConfig()));
            }
            case "MonitoringInputs": {
                return Optional.ofNullable(clazz.cast(this.monitoringInputs()));
            }
            case "MonitoringOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.monitoringOutputConfig()));
            }
            case "MonitoringResources": {
                return Optional.ofNullable(clazz.cast(this.monitoringResources()));
            }
            case "MonitoringAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.monitoringAppSpecification()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringJobDefinition, T> g) {
        return obj -> g.apply((MonitoringJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonitoringBaselineConfig baselineConfig;
        private List<MonitoringInput> monitoringInputs = DefaultSdkAutoConstructList.getInstance();
        private MonitoringOutputConfig monitoringOutputConfig;
        private MonitoringResources monitoringResources;
        private MonitoringAppSpecification monitoringAppSpecification;
        private MonitoringStoppingCondition stoppingCondition;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private NetworkConfig networkConfig;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringJobDefinition model) {
            this.baselineConfig(model.baselineConfig);
            this.monitoringInputs(model.monitoringInputs);
            this.monitoringOutputConfig(model.monitoringOutputConfig);
            this.monitoringResources(model.monitoringResources);
            this.monitoringAppSpecification(model.monitoringAppSpecification);
            this.stoppingCondition(model.stoppingCondition);
            this.environment(model.environment);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
        }

        public final MonitoringBaselineConfig.Builder getBaselineConfig() {
            return this.baselineConfig != null ? this.baselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder baselineConfig(MonitoringBaselineConfig baselineConfig) {
            this.baselineConfig = baselineConfig;
            return this;
        }

        public final void setBaselineConfig(MonitoringBaselineConfig.BuilderImpl baselineConfig) {
            this.baselineConfig = baselineConfig != null ? baselineConfig.build() : null;
        }

        public final Collection<MonitoringInput.Builder> getMonitoringInputs() {
            if (this.monitoringInputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.monitoringInputs != null ? (Collection)this.monitoringInputs.stream().map(MonitoringInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder monitoringInputs(Collection<MonitoringInput> monitoringInputs) {
            this.monitoringInputs = MonitoringInputsCopier.copy(monitoringInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringInputs(MonitoringInput ... monitoringInputs) {
            this.monitoringInputs(Arrays.asList(monitoringInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringInputs(Consumer<MonitoringInput.Builder> ... monitoringInputs) {
            this.monitoringInputs(Stream.of(monitoringInputs).map(c -> (MonitoringInput)((MonitoringInput.Builder)MonitoringInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMonitoringInputs(Collection<MonitoringInput.BuilderImpl> monitoringInputs) {
            this.monitoringInputs = MonitoringInputsCopier.copyFromBuilder(monitoringInputs);
        }

        public final MonitoringOutputConfig.Builder getMonitoringOutputConfig() {
            return this.monitoringOutputConfig != null ? this.monitoringOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder monitoringOutputConfig(MonitoringOutputConfig monitoringOutputConfig) {
            this.monitoringOutputConfig = monitoringOutputConfig;
            return this;
        }

        public final void setMonitoringOutputConfig(MonitoringOutputConfig.BuilderImpl monitoringOutputConfig) {
            this.monitoringOutputConfig = monitoringOutputConfig != null ? monitoringOutputConfig.build() : null;
        }

        public final MonitoringResources.Builder getMonitoringResources() {
            return this.monitoringResources != null ? this.monitoringResources.toBuilder() : null;
        }

        @Override
        public final Builder monitoringResources(MonitoringResources monitoringResources) {
            this.monitoringResources = monitoringResources;
            return this;
        }

        public final void setMonitoringResources(MonitoringResources.BuilderImpl monitoringResources) {
            this.monitoringResources = monitoringResources != null ? monitoringResources.build() : null;
        }

        public final MonitoringAppSpecification.Builder getMonitoringAppSpecification() {
            return this.monitoringAppSpecification != null ? this.monitoringAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder monitoringAppSpecification(MonitoringAppSpecification monitoringAppSpecification) {
            this.monitoringAppSpecification = monitoringAppSpecification;
            return this;
        }

        public final void setMonitoringAppSpecification(MonitoringAppSpecification.BuilderImpl monitoringAppSpecification) {
            this.monitoringAppSpecification = monitoringAppSpecification != null ? monitoringAppSpecification.build() : null;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public MonitoringJobDefinition build() {
            return new MonitoringJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringJobDefinition> {
        public Builder baselineConfig(MonitoringBaselineConfig var1);

        default public Builder baselineConfig(Consumer<MonitoringBaselineConfig.Builder> baselineConfig) {
            return this.baselineConfig((MonitoringBaselineConfig)((MonitoringBaselineConfig.Builder)MonitoringBaselineConfig.builder().applyMutation(baselineConfig)).build());
        }

        public Builder monitoringInputs(Collection<MonitoringInput> var1);

        public Builder monitoringInputs(MonitoringInput ... var1);

        public Builder monitoringInputs(Consumer<MonitoringInput.Builder> ... var1);

        public Builder monitoringOutputConfig(MonitoringOutputConfig var1);

        default public Builder monitoringOutputConfig(Consumer<MonitoringOutputConfig.Builder> monitoringOutputConfig) {
            return this.monitoringOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(monitoringOutputConfig)).build());
        }

        public Builder monitoringResources(MonitoringResources var1);

        default public Builder monitoringResources(Consumer<MonitoringResources.Builder> monitoringResources) {
            return this.monitoringResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(monitoringResources)).build());
        }

        public Builder monitoringAppSpecification(MonitoringAppSpecification var1);

        default public Builder monitoringAppSpecification(Consumer<MonitoringAppSpecification.Builder> monitoringAppSpecification) {
            return this.monitoringAppSpecification((MonitoringAppSpecification)((MonitoringAppSpecification.Builder)MonitoringAppSpecification.builder().applyMutation(monitoringAppSpecification)).build());
        }

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder environment(Map<String, String> var1);

        public Builder networkConfig(NetworkConfig var1);

        default public Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return this.networkConfig((NetworkConfig)((NetworkConfig.Builder)NetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);
    }
}

