/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion;
import software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestionListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSearchSuggestionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, GetSearchSuggestionsResponse> {
    private static final SdkField<List<PropertyNameSuggestion>> PROPERTY_NAME_SUGGESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertyNameSuggestions").getter(GetSearchSuggestionsResponse.getter(GetSearchSuggestionsResponse::propertyNameSuggestions)).setter(GetSearchSuggestionsResponse.setter(Builder::propertyNameSuggestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyNameSuggestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyNameSuggestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_SUGGESTIONS_FIELD));
    private final List<PropertyNameSuggestion> propertyNameSuggestions;

    private GetSearchSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.propertyNameSuggestions = builder.propertyNameSuggestions;
    }

    public boolean hasPropertyNameSuggestions() {
        return this.propertyNameSuggestions != null && !(this.propertyNameSuggestions instanceof SdkAutoConstructList);
    }

    public List<PropertyNameSuggestion> propertyNameSuggestions() {
        return this.propertyNameSuggestions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyNameSuggestions() ? this.propertyNameSuggestions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchSuggestionsResponse)) {
            return false;
        }
        GetSearchSuggestionsResponse other = (GetSearchSuggestionsResponse)((Object)obj);
        return this.hasPropertyNameSuggestions() == other.hasPropertyNameSuggestions() && Objects.equals(this.propertyNameSuggestions(), other.propertyNameSuggestions());
    }

    public String toString() {
        return ToString.builder((String)"GetSearchSuggestionsResponse").add("PropertyNameSuggestions", this.hasPropertyNameSuggestions() ? this.propertyNameSuggestions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyNameSuggestions": {
                return Optional.ofNullable(clazz.cast(this.propertyNameSuggestions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSearchSuggestionsResponse, T> g) {
        return obj -> g.apply((GetSearchSuggestionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<PropertyNameSuggestion> propertyNameSuggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchSuggestionsResponse model) {
            super(model);
            this.propertyNameSuggestions(model.propertyNameSuggestions);
        }

        public final Collection<PropertyNameSuggestion.Builder> getPropertyNameSuggestions() {
            if (this.propertyNameSuggestions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertyNameSuggestions != null ? (Collection)this.propertyNameSuggestions.stream().map(PropertyNameSuggestion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propertyNameSuggestions(Collection<PropertyNameSuggestion> propertyNameSuggestions) {
            this.propertyNameSuggestions = PropertyNameSuggestionListCopier.copy(propertyNameSuggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyNameSuggestions(PropertyNameSuggestion ... propertyNameSuggestions) {
            this.propertyNameSuggestions(Arrays.asList(propertyNameSuggestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyNameSuggestions(Consumer<PropertyNameSuggestion.Builder> ... propertyNameSuggestions) {
            this.propertyNameSuggestions(Stream.of(propertyNameSuggestions).map(c -> (PropertyNameSuggestion)((PropertyNameSuggestion.Builder)PropertyNameSuggestion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyNameSuggestions(Collection<PropertyNameSuggestion.BuilderImpl> propertyNameSuggestions) {
            this.propertyNameSuggestions = PropertyNameSuggestionListCopier.copyFromBuilder(propertyNameSuggestions);
        }

        @Override
        public GetSearchSuggestionsResponse build() {
            return new GetSearchSuggestionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSearchSuggestionsResponse> {
        public Builder propertyNameSuggestions(Collection<PropertyNameSuggestion> var1);

        public Builder propertyNameSuggestions(PropertyNameSuggestion ... var1);

        public Builder propertyNameSuggestions(Consumer<PropertyNameSuggestion.Builder> ... var1);
    }
}

