/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.Workteam;
import software.amazon.awssdk.services.sagemaker.model.WorkteamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkteamsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListWorkteamsResponse> {
    private static final SdkField<List<Workteam>> WORKTEAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Workteams").getter(ListWorkteamsResponse.getter(ListWorkteamsResponse::workteams)).setter(ListWorkteamsResponse.setter(Builder::workteams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workteams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workteam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkteamsResponse.getter(ListWorkteamsResponse::nextToken)).setter(ListWorkteamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Workteam> workteams;
    private final String nextToken;

    private ListWorkteamsResponse(BuilderImpl builder) {
        super(builder);
        this.workteams = builder.workteams;
        this.nextToken = builder.nextToken;
    }

    public boolean hasWorkteams() {
        return this.workteams != null && !(this.workteams instanceof SdkAutoConstructList);
    }

    public List<Workteam> workteams() {
        return this.workteams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workteams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkteamsResponse)) {
            return false;
        }
        ListWorkteamsResponse other = (ListWorkteamsResponse)((Object)obj);
        return Objects.equals(this.workteams(), other.workteams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWorkteamsResponse").add("Workteams", this.workteams()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Workteams": {
                return Optional.ofNullable(clazz.cast(this.workteams()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkteamsResponse, T> g) {
        return obj -> g.apply((ListWorkteamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<Workteam> workteams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkteamsResponse model) {
            super(model);
            this.workteams(model.workteams);
            this.nextToken(model.nextToken);
        }

        public final Collection<Workteam.Builder> getWorkteams() {
            return this.workteams != null ? (Collection)this.workteams.stream().map(Workteam::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workteams(Collection<Workteam> workteams) {
            this.workteams = WorkteamsCopier.copy(workteams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workteams(Workteam ... workteams) {
            this.workteams(Arrays.asList(workteams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workteams(Consumer<Workteam.Builder> ... workteams) {
            this.workteams(Stream.of(workteams).map(c -> (Workteam)((Workteam.Builder)Workteam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkteams(Collection<Workteam.BuilderImpl> workteams) {
            this.workteams = WorkteamsCopier.copyFromBuilder(workteams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorkteamsResponse build() {
            return new ListWorkteamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkteamsResponse> {
        public Builder workteams(Collection<Workteam> var1);

        public Builder workteams(Workteam ... var1);

        public Builder workteams(Consumer<Workteam.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

