/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UiTemplateInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UiTemplateInfo> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(UiTemplateInfo.getter(UiTemplateInfo::url)).setter(UiTemplateInfo.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentSha256").getter(UiTemplateInfo.getter(UiTemplateInfo::contentSha256)).setter(UiTemplateInfo.setter(Builder::contentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CONTENT_SHA256_FIELD));
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String contentSha256;

    private UiTemplateInfo(BuilderImpl builder) {
        this.url = builder.url;
        this.contentSha256 = builder.contentSha256;
    }

    public String url() {
        return this.url;
    }

    public String contentSha256() {
        return this.contentSha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSha256());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UiTemplateInfo)) {
            return false;
        }
        UiTemplateInfo other = (UiTemplateInfo)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.contentSha256(), other.contentSha256());
    }

    public String toString() {
        return ToString.builder((String)"UiTemplateInfo").add("Url", (Object)this.url()).add("ContentSha256", (Object)this.contentSha256()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ContentSha256": {
                return Optional.ofNullable(clazz.cast(this.contentSha256()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UiTemplateInfo, T> g) {
        return obj -> g.apply((UiTemplateInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String contentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(UiTemplateInfo model) {
            this.url(model.url);
            this.contentSha256(model.contentSha256);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getContentSha256() {
            return this.contentSha256;
        }

        @Override
        public final Builder contentSha256(String contentSha256) {
            this.contentSha256 = contentSha256;
            return this;
        }

        public final void setContentSha256(String contentSha256) {
            this.contentSha256 = contentSha256;
        }

        public UiTemplateInfo build() {
            return new UiTemplateInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UiTemplateInfo> {
        public Builder url(String var1);

        public Builder contentSha256(String var1);
    }
}

