/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageValidationSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageValidationSpecification> {
    private static final SdkField<String> VALIDATION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationRole").getter(ModelPackageValidationSpecification.getter(ModelPackageValidationSpecification::validationRole)).setter(ModelPackageValidationSpecification.setter(Builder::validationRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRole").build()}).build();
    private static final SdkField<List<ModelPackageValidationProfile>> VALIDATION_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationProfiles").getter(ModelPackageValidationSpecification.getter(ModelPackageValidationSpecification::validationProfiles)).setter(ModelPackageValidationSpecification.setter(Builder::validationProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageValidationProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ROLE_FIELD, VALIDATION_PROFILES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String validationRole;
    private final List<ModelPackageValidationProfile> validationProfiles;

    private ModelPackageValidationSpecification(BuilderImpl builder) {
        this.validationRole = builder.validationRole;
        this.validationProfiles = builder.validationProfiles;
    }

    public String validationRole() {
        return this.validationRole;
    }

    public boolean hasValidationProfiles() {
        return this.validationProfiles != null && !(this.validationProfiles instanceof SdkAutoConstructList);
    }

    public List<ModelPackageValidationProfile> validationProfiles() {
        return this.validationProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationProfiles() ? this.validationProfiles() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageValidationSpecification)) {
            return false;
        }
        ModelPackageValidationSpecification other = (ModelPackageValidationSpecification)obj;
        return Objects.equals(this.validationRole(), other.validationRole()) && this.hasValidationProfiles() == other.hasValidationProfiles() && Objects.equals(this.validationProfiles(), other.validationProfiles());
    }

    public String toString() {
        return ToString.builder((String)"ModelPackageValidationSpecification").add("ValidationRole", (Object)this.validationRole()).add("ValidationProfiles", this.hasValidationProfiles() ? this.validationProfiles() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationRole": {
                return Optional.ofNullable(clazz.cast(this.validationRole()));
            }
            case "ValidationProfiles": {
                return Optional.ofNullable(clazz.cast(this.validationProfiles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageValidationSpecification, T> g) {
        return obj -> g.apply((ModelPackageValidationSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String validationRole;
        private List<ModelPackageValidationProfile> validationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageValidationSpecification model) {
            this.validationRole(model.validationRole);
            this.validationProfiles(model.validationProfiles);
        }

        public final String getValidationRole() {
            return this.validationRole;
        }

        @Override
        public final Builder validationRole(String validationRole) {
            this.validationRole = validationRole;
            return this;
        }

        public final void setValidationRole(String validationRole) {
            this.validationRole = validationRole;
        }

        public final Collection<ModelPackageValidationProfile.Builder> getValidationProfiles() {
            if (this.validationProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validationProfiles != null ? (Collection)this.validationProfiles.stream().map(ModelPackageValidationProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationProfiles(Collection<ModelPackageValidationProfile> validationProfiles) {
            this.validationProfiles = ModelPackageValidationProfilesCopier.copy(validationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(ModelPackageValidationProfile ... validationProfiles) {
            this.validationProfiles(Arrays.asList(validationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(Consumer<ModelPackageValidationProfile.Builder> ... validationProfiles) {
            this.validationProfiles(Stream.of(validationProfiles).map(c -> (ModelPackageValidationProfile)((ModelPackageValidationProfile.Builder)ModelPackageValidationProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationProfiles(Collection<ModelPackageValidationProfile.BuilderImpl> validationProfiles) {
            this.validationProfiles = ModelPackageValidationProfilesCopier.copyFromBuilder(validationProfiles);
        }

        public ModelPackageValidationSpecification build() {
            return new ModelPackageValidationSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageValidationSpecification> {
        public Builder validationRole(String var1);

        public Builder validationProfiles(Collection<ModelPackageValidationProfile> var1);

        public Builder validationProfiles(ModelPackageValidationProfile ... var1);

        public Builder validationProfiles(Consumer<ModelPackageValidationProfile.Builder> ... var1);
    }
}

