/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmStatusDetails> {
    private static final SdkField<List<AlgorithmStatusItem>> VALIDATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationStatuses").getter(AlgorithmStatusDetails.getter(AlgorithmStatusDetails::validationStatuses)).setter(AlgorithmStatusDetails.setter(Builder::validationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlgorithmStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AlgorithmStatusItem>> IMAGE_SCAN_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageScanStatuses").getter(AlgorithmStatusDetails.getter(AlgorithmStatusDetails::imageScanStatuses)).setter(AlgorithmStatusDetails.setter(Builder::imageScanStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlgorithmStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_STATUSES_FIELD, IMAGE_SCAN_STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AlgorithmStatusItem> validationStatuses;
    private final List<AlgorithmStatusItem> imageScanStatuses;

    private AlgorithmStatusDetails(BuilderImpl builder) {
        this.validationStatuses = builder.validationStatuses;
        this.imageScanStatuses = builder.imageScanStatuses;
    }

    public boolean hasValidationStatuses() {
        return this.validationStatuses != null && !(this.validationStatuses instanceof SdkAutoConstructList);
    }

    public List<AlgorithmStatusItem> validationStatuses() {
        return this.validationStatuses;
    }

    public boolean hasImageScanStatuses() {
        return this.imageScanStatuses != null && !(this.imageScanStatuses instanceof SdkAutoConstructList);
    }

    public List<AlgorithmStatusItem> imageScanStatuses() {
        return this.imageScanStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanStatuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmStatusDetails)) {
            return false;
        }
        AlgorithmStatusDetails other = (AlgorithmStatusDetails)obj;
        return Objects.equals(this.validationStatuses(), other.validationStatuses()) && Objects.equals(this.imageScanStatuses(), other.imageScanStatuses());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmStatusDetails").add("ValidationStatuses", this.validationStatuses()).add("ImageScanStatuses", this.imageScanStatuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationStatuses": {
                return Optional.ofNullable(clazz.cast(this.validationStatuses()));
            }
            case "ImageScanStatuses": {
                return Optional.ofNullable(clazz.cast(this.imageScanStatuses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmStatusDetails, T> g) {
        return obj -> g.apply((AlgorithmStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AlgorithmStatusItem> validationStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<AlgorithmStatusItem> imageScanStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmStatusDetails model) {
            this.validationStatuses(model.validationStatuses);
            this.imageScanStatuses(model.imageScanStatuses);
        }

        public final Collection<AlgorithmStatusItem.Builder> getValidationStatuses() {
            return this.validationStatuses != null ? (Collection)this.validationStatuses.stream().map(AlgorithmStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationStatuses(Collection<AlgorithmStatusItem> validationStatuses) {
            this.validationStatuses = AlgorithmStatusItemListCopier.copy(validationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(AlgorithmStatusItem ... validationStatuses) {
            this.validationStatuses(Arrays.asList(validationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(Consumer<AlgorithmStatusItem.Builder> ... validationStatuses) {
            this.validationStatuses(Stream.of(validationStatuses).map(c -> (AlgorithmStatusItem)((AlgorithmStatusItem.Builder)AlgorithmStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationStatuses(Collection<AlgorithmStatusItem.BuilderImpl> validationStatuses) {
            this.validationStatuses = AlgorithmStatusItemListCopier.copyFromBuilder(validationStatuses);
        }

        public final Collection<AlgorithmStatusItem.Builder> getImageScanStatuses() {
            return this.imageScanStatuses != null ? (Collection)this.imageScanStatuses.stream().map(AlgorithmStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageScanStatuses(Collection<AlgorithmStatusItem> imageScanStatuses) {
            this.imageScanStatuses = AlgorithmStatusItemListCopier.copy(imageScanStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(AlgorithmStatusItem ... imageScanStatuses) {
            this.imageScanStatuses(Arrays.asList(imageScanStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(Consumer<AlgorithmStatusItem.Builder> ... imageScanStatuses) {
            this.imageScanStatuses(Stream.of(imageScanStatuses).map(c -> (AlgorithmStatusItem)((AlgorithmStatusItem.Builder)AlgorithmStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageScanStatuses(Collection<AlgorithmStatusItem.BuilderImpl> imageScanStatuses) {
            this.imageScanStatuses = AlgorithmStatusItemListCopier.copyFromBuilder(imageScanStatuses);
        }

        public AlgorithmStatusDetails build() {
            return new AlgorithmStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmStatusDetails> {
        public Builder validationStatuses(Collection<AlgorithmStatusItem> var1);

        public Builder validationStatuses(AlgorithmStatusItem ... var1);

        public Builder validationStatuses(Consumer<AlgorithmStatusItem.Builder> ... var1);

        public Builder imageScanStatuses(Collection<AlgorithmStatusItem> var1);

        public Builder imageScanStatuses(AlgorithmStatusItem ... var1);

        public Builder imageScanStatuses(Consumer<AlgorithmStatusItem.Builder> ... var1);
    }
}

