/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange;
import software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangesCopier;
import software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange;
import software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRangesCopier;
import software.amazon.awssdk.services.sagemaker.model.IntegerParameterRange;
import software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterRanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterRanges> {
    private static final SdkField<List<IntegerParameterRange>> INTEGER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerParameterRanges").getter(ParameterRanges.getter(ParameterRanges::integerParameterRanges)).setter(ParameterRanges.setter(Builder::integerParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegerParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContinuousParameterRange>> CONTINUOUS_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContinuousParameterRanges").getter(ParameterRanges.getter(ParameterRanges::continuousParameterRanges)).setter(ParameterRanges.setter(Builder::continuousParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContinuousParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CategoricalParameterRange>> CATEGORICAL_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategoricalParameterRanges").getter(ParameterRanges.getter(ParameterRanges::categoricalParameterRanges)).setter(ParameterRanges.setter(Builder::categoricalParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoricalParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_PARAMETER_RANGES_FIELD, CONTINUOUS_PARAMETER_RANGES_FIELD, CATEGORICAL_PARAMETER_RANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<IntegerParameterRange> integerParameterRanges;
    private final List<ContinuousParameterRange> continuousParameterRanges;
    private final List<CategoricalParameterRange> categoricalParameterRanges;

    private ParameterRanges(BuilderImpl builder) {
        this.integerParameterRanges = builder.integerParameterRanges;
        this.continuousParameterRanges = builder.continuousParameterRanges;
        this.categoricalParameterRanges = builder.categoricalParameterRanges;
    }

    public boolean hasIntegerParameterRanges() {
        return this.integerParameterRanges != null && !(this.integerParameterRanges instanceof SdkAutoConstructList);
    }

    public List<IntegerParameterRange> integerParameterRanges() {
        return this.integerParameterRanges;
    }

    public boolean hasContinuousParameterRanges() {
        return this.continuousParameterRanges != null && !(this.continuousParameterRanges instanceof SdkAutoConstructList);
    }

    public List<ContinuousParameterRange> continuousParameterRanges() {
        return this.continuousParameterRanges;
    }

    public boolean hasCategoricalParameterRanges() {
        return this.categoricalParameterRanges != null && !(this.categoricalParameterRanges instanceof SdkAutoConstructList);
    }

    public List<CategoricalParameterRange> categoricalParameterRanges() {
        return this.categoricalParameterRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integerParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoricalParameterRanges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterRanges)) {
            return false;
        }
        ParameterRanges other = (ParameterRanges)obj;
        return Objects.equals(this.integerParameterRanges(), other.integerParameterRanges()) && Objects.equals(this.continuousParameterRanges(), other.continuousParameterRanges()) && Objects.equals(this.categoricalParameterRanges(), other.categoricalParameterRanges());
    }

    public String toString() {
        return ToString.builder((String)"ParameterRanges").add("IntegerParameterRanges", this.integerParameterRanges()).add("ContinuousParameterRanges", this.continuousParameterRanges()).add("CategoricalParameterRanges", this.categoricalParameterRanges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegerParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.integerParameterRanges()));
            }
            case "ContinuousParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.continuousParameterRanges()));
            }
            case "CategoricalParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.categoricalParameterRanges()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterRanges, T> g) {
        return obj -> g.apply((ParameterRanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IntegerParameterRange> integerParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<ContinuousParameterRange> continuousParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<CategoricalParameterRange> categoricalParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterRanges model) {
            this.integerParameterRanges(model.integerParameterRanges);
            this.continuousParameterRanges(model.continuousParameterRanges);
            this.categoricalParameterRanges(model.categoricalParameterRanges);
        }

        public final Collection<IntegerParameterRange.Builder> getIntegerParameterRanges() {
            return this.integerParameterRanges != null ? (Collection)this.integerParameterRanges.stream().map(IntegerParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copy(integerParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(IntegerParameterRange ... integerParameterRanges) {
            this.integerParameterRanges(Arrays.asList(integerParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder> ... integerParameterRanges) {
            this.integerParameterRanges(Stream.of(integerParameterRanges).map(c -> (IntegerParameterRange)((IntegerParameterRange.Builder)IntegerParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerParameterRanges(Collection<IntegerParameterRange.BuilderImpl> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copyFromBuilder(integerParameterRanges);
        }

        public final Collection<ContinuousParameterRange.Builder> getContinuousParameterRanges() {
            return this.continuousParameterRanges != null ? (Collection)this.continuousParameterRanges.stream().map(ContinuousParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copy(continuousParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(ContinuousParameterRange ... continuousParameterRanges) {
            this.continuousParameterRanges(Arrays.asList(continuousParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder> ... continuousParameterRanges) {
            this.continuousParameterRanges(Stream.of(continuousParameterRanges).map(c -> (ContinuousParameterRange)((ContinuousParameterRange.Builder)ContinuousParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContinuousParameterRanges(Collection<ContinuousParameterRange.BuilderImpl> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copyFromBuilder(continuousParameterRanges);
        }

        public final Collection<CategoricalParameterRange.Builder> getCategoricalParameterRanges() {
            return this.categoricalParameterRanges != null ? (Collection)this.categoricalParameterRanges.stream().map(CategoricalParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copy(categoricalParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(CategoricalParameterRange ... categoricalParameterRanges) {
            this.categoricalParameterRanges(Arrays.asList(categoricalParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder> ... categoricalParameterRanges) {
            this.categoricalParameterRanges(Stream.of(categoricalParameterRanges).map(c -> (CategoricalParameterRange)((CategoricalParameterRange.Builder)CategoricalParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategoricalParameterRanges(Collection<CategoricalParameterRange.BuilderImpl> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copyFromBuilder(categoricalParameterRanges);
        }

        public ParameterRanges build() {
            return new ParameterRanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterRanges> {
        public Builder integerParameterRanges(Collection<IntegerParameterRange> var1);

        public Builder integerParameterRanges(IntegerParameterRange ... var1);

        public Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder> ... var1);

        public Builder continuousParameterRanges(Collection<ContinuousParameterRange> var1);

        public Builder continuousParameterRanges(ContinuousParameterRange ... var1);

        public Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder> ... var1);

        public Builder categoricalParameterRanges(Collection<CategoricalParameterRange> var1);

        public Builder categoricalParameterRanges(CategoricalParameterRange ... var1);

        public Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder> ... var1);
    }
}

