/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoConfig> {
    private static final SdkField<String> USER_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CognitoConfig.getter(CognitoConfig::userPool)).setter(CognitoConfig.setter(Builder::userPool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPool").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CognitoConfig.getter(CognitoConfig::clientId)).setter(CognitoConfig.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_FIELD, CLIENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPool;
    private final String clientId;

    private CognitoConfig(BuilderImpl builder) {
        this.userPool = builder.userPool;
        this.clientId = builder.clientId;
    }

    public String userPool() {
        return this.userPool;
    }

    public String clientId() {
        return this.clientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPool());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoConfig)) {
            return false;
        }
        CognitoConfig other = (CognitoConfig)obj;
        return Objects.equals(this.userPool(), other.userPool()) && Objects.equals(this.clientId(), other.clientId());
    }

    public String toString() {
        return ToString.builder((String)"CognitoConfig").add("UserPool", (Object)this.userPool()).add("ClientId", (Object)this.clientId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPool": {
                return Optional.ofNullable(clazz.cast(this.userPool()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoConfig, T> g) {
        return obj -> g.apply((CognitoConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPool;
        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoConfig model) {
            this.userPool(model.userPool);
            this.clientId(model.clientId);
        }

        public final String getUserPool() {
            return this.userPool;
        }

        @Override
        public final Builder userPool(String userPool) {
            this.userPool = userPool;
            return this;
        }

        public final void setUserPool(String userPool) {
            this.userPool = userPool;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public CognitoConfig build() {
            return new CognitoConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoConfig> {
        public Builder userPool(String var1);

        public Builder clientId(String var1);
    }
}

