/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RenderableTask;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.UiTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenderUiTemplateRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, RenderUiTemplateRequest> {
    private static final SdkField<UiTemplate> UI_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RenderUiTemplateRequest.getter(RenderUiTemplateRequest::uiTemplate)).setter(RenderUiTemplateRequest.setter(Builder::uiTemplate)).constructor(UiTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()}).build();
    private static final SdkField<RenderableTask> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RenderUiTemplateRequest.getter(RenderUiTemplateRequest::task)).setter(RenderUiTemplateRequest.setter(Builder::task)).constructor(RenderableTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RenderUiTemplateRequest.getter(RenderUiTemplateRequest::roleArn)).setter(RenderUiTemplateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UI_TEMPLATE_FIELD, TASK_FIELD, ROLE_ARN_FIELD));
    private final UiTemplate uiTemplate;
    private final RenderableTask task;
    private final String roleArn;

    private RenderUiTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.uiTemplate = builder.uiTemplate;
        this.task = builder.task;
        this.roleArn = builder.roleArn;
    }

    public UiTemplate uiTemplate() {
        return this.uiTemplate;
    }

    public RenderableTask task() {
        return this.task;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uiTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderUiTemplateRequest)) {
            return false;
        }
        RenderUiTemplateRequest other = (RenderUiTemplateRequest)((Object)obj);
        return Objects.equals(this.uiTemplate(), other.uiTemplate()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"RenderUiTemplateRequest").add("UiTemplate", (Object)this.uiTemplate()).add("Task", (Object)this.task()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UiTemplate": {
                return Optional.ofNullable(clazz.cast(this.uiTemplate()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenderUiTemplateRequest, T> g) {
        return obj -> g.apply((RenderUiTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private UiTemplate uiTemplate;
        private RenderableTask task;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RenderUiTemplateRequest model) {
            super(model);
            this.uiTemplate(model.uiTemplate);
            this.task(model.task);
            this.roleArn(model.roleArn);
        }

        public final UiTemplate.Builder getUiTemplate() {
            return this.uiTemplate != null ? this.uiTemplate.toBuilder() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplate uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final void setUiTemplate(UiTemplate.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        public final RenderableTask.Builder getTask() {
            return this.task != null ? this.task.toBuilder() : null;
        }

        @Override
        public final Builder task(RenderableTask task) {
            this.task = task;
            return this;
        }

        public final void setTask(RenderableTask.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenderUiTemplateRequest build() {
            return new RenderUiTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RenderUiTemplateRequest> {
        public Builder uiTemplate(UiTemplate var1);

        default public Builder uiTemplate(Consumer<UiTemplate.Builder> uiTemplate) {
            return this.uiTemplate((UiTemplate)((UiTemplate.Builder)UiTemplate.builder().applyMutation(uiTemplate)).build());
        }

        public Builder task(RenderableTask var1);

        default public Builder task(Consumer<RenderableTask.Builder> task) {
            return this.task((RenderableTask)((RenderableTask.Builder)RenderableTask.builder().applyMutation(task)).build());
        }

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

