/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the location of the channel data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformDataSource.Builder, TransformDataSource> {
    private static final SdkField<TransformS3DataSource> S3_DATA_SOURCE_FIELD = SdkField
            .<TransformS3DataSource> builder(MarshallingType.SDK_POJO).getter(getter(TransformDataSource::s3DataSource))
            .setter(setter(Builder::s3DataSource)).constructor(TransformS3DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TransformS3DataSource s3DataSource;

    private TransformDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    /**
     * <p>
     * The S3 location of the data source that is associated with a channel.
     * </p>
     * 
     * @return The S3 location of the data source that is associated with a channel.
     */
    public TransformS3DataSource s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformDataSource)) {
            return false;
        }
        TransformDataSource other = (TransformDataSource) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransformDataSource").add("S3DataSource", s3DataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformDataSource, T> g) {
        return obj -> g.apply((TransformDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformDataSource> {
        /**
         * <p>
         * The S3 location of the data source that is associated with a channel.
         * </p>
         * 
         * @param s3DataSource
         *        The S3 location of the data source that is associated with a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(TransformS3DataSource s3DataSource);

        /**
         * <p>
         * The S3 location of the data source that is associated with a channel.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformS3DataSource.Builder} avoiding the need
         * to create one manually via {@link TransformS3DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformS3DataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #s3DataSource(TransformS3DataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link TransformS3DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(TransformS3DataSource)
         */
        default Builder s3DataSource(Consumer<TransformS3DataSource.Builder> s3DataSource) {
            return s3DataSource(TransformS3DataSource.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TransformS3DataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformDataSource model) {
            s3DataSource(model.s3DataSource);
        }

        public final TransformS3DataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3DataSource(TransformS3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final void setS3DataSource(TransformS3DataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public TransformDataSource build() {
            return new TransformDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
