/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringSchedulesRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListMonitoringSchedulesRequest.Builder, ListMonitoringSchedulesRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListMonitoringSchedulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListMonitoringSchedulesRequest::creationTimeBefore)).setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListMonitoringSchedulesRequest::creationTimeAfter)).setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListMonitoringSchedulesRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListMonitoringSchedulesRequest::lastModifiedTimeAfter)).setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMonitoringSchedulesRequest::statusEqualsAsString)).setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD,
            CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD,
            LAST_MODIFIED_TIME_AFTER_FIELD, STATUS_EQUALS_FIELD));

    private final String endpointName;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final String statusEquals;

    private ListMonitoringSchedulesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.statusEquals = builder.statusEquals;
    }

    /**
     * <p>
     * Name of a specific endpoint to fetch schedules for.
     * </p>
     * 
     * @return Name of a specific endpoint to fetch schedules for.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The
     * default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringScheduleSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code>
     *         field. The default is <code>CreationTime</code>.
     * @see MonitoringScheduleSortKey
     */
    public MonitoringScheduleSortKey sortBy() {
        return MonitoringScheduleSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The
     * default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringScheduleSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code>
     *         field. The default is <code>CreationTime</code>.
     * @see MonitoringScheduleSortKey
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     * <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next
     * request.
     * </p>
     * 
     * @return The token returned if the response is truncated. To retrieve the next set of job executions, use it in
     *         the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of jobs to return in the response. The default value is 10.
     * </p>
     * 
     * @return The maximum number of jobs to return in the response. The default value is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter for monitoring schedules whose name contains a specified string.
     * </p>
     * 
     * @return Filter for monitoring schedules whose name contains a specified string.
     */
    public String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules created before a specified time.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules created before a specified time.
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules created after a specified time.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules created after a specified time.
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules modified before a specified time.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules modified before a specified time.
     */
    public Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules modified after a specified time.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules modified after a specified time.
     */
    public Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules modified before a specified time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules modified before a specified time.
     * @see ScheduleStatus
     */
    public ScheduleStatus statusEquals() {
        return ScheduleStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * A filter that returns only monitoring schedules modified before a specified time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that returns only monitoring schedules modified before a specified time.
     * @see ScheduleStatus
     */
    public String statusEqualsAsString() {
        return statusEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringSchedulesRequest)) {
            return false;
        }
        ListMonitoringSchedulesRequest other = (ListMonitoringSchedulesRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMonitoringSchedulesRequest").add("EndpointName", endpointName())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("NameContains", nameContains())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter())
                .add("LastModifiedTimeBefore", lastModifiedTimeBefore()).add("LastModifiedTimeAfter", lastModifiedTimeAfter())
                .add("StatusEquals", statusEqualsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringSchedulesRequest, T> g) {
        return obj -> g.apply((ListMonitoringSchedulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMonitoringSchedulesRequest> {
        /**
         * <p>
         * Name of a specific endpoint to fetch schedules for.
         * </p>
         * 
         * @param endpointName
         *        Name of a specific endpoint to fetch schedules for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field.
         * The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code>
         *        field. The default is <code>CreationTime</code>.
         * @see MonitoringScheduleSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringScheduleSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field.
         * The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code>
         *        field. The default is <code>CreationTime</code>.
         * @see MonitoringScheduleSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringScheduleSortKey
         */
        Builder sortBy(MonitoringScheduleSortKey sortBy);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         * <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The token returned if the response is truncated. To retrieve the next set of job executions, use it in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        The token returned if the response is truncated. To retrieve the next set of job executions, use it in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of jobs to return in the response. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of jobs to return in the response. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter for monitoring schedules whose name contains a specified string.
         * </p>
         * 
         * @param nameContains
         *        Filter for monitoring schedules whose name contains a specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that returns only monitoring schedules created before a specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only monitoring schedules created before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only monitoring schedules created after a specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only monitoring schedules created after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns only monitoring schedules modified before a specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        A filter that returns only monitoring schedules modified before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * A filter that returns only monitoring schedules modified after a specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        A filter that returns only monitoring schedules modified after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * A filter that returns only monitoring schedules modified before a specified time.
         * </p>
         * 
         * @param statusEquals
         *        A filter that returns only monitoring schedules modified before a specified time.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * A filter that returns only monitoring schedules modified before a specified time.
         * </p>
         * 
         * @param statusEquals
         *        A filter that returns only monitoring schedules modified before a specified time.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder statusEquals(ScheduleStatus statusEquals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant lastModifiedTimeBefore;

        private Instant lastModifiedTimeAfter;

        private String statusEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringSchedulesRequest model) {
            super(model);
            endpointName(model.endpointName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            statusEquals(model.statusEquals);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getSortByAsString() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(MonitoringScheduleSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final String getStatusEqualsAsString() {
            return statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ScheduleStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMonitoringSchedulesRequest build() {
            return new ListMonitoringSchedulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
