/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.GitConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositorySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositorySummary> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeRepositorySummary.getter(CodeRepositorySummary::codeRepositoryName)).setter(CodeRepositorySummary.setter(Builder::codeRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build()}).build();
    private static final SdkField<String> CODE_REPOSITORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeRepositorySummary.getter(CodeRepositorySummary::codeRepositoryArn)).setter(CodeRepositorySummary.setter(Builder::codeRepositoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CodeRepositorySummary.getter(CodeRepositorySummary::creationTime)).setter(CodeRepositorySummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CodeRepositorySummary.getter(CodeRepositorySummary::lastModifiedTime)).setter(CodeRepositorySummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<GitConfig> GIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CodeRepositorySummary.getter(CodeRepositorySummary::gitConfig)).setter(CodeRepositorySummary.setter(Builder::gitConfig)).constructor(GitConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD, CODE_REPOSITORY_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, GIT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codeRepositoryName;
    private final String codeRepositoryArn;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final GitConfig gitConfig;

    private CodeRepositorySummary(BuilderImpl builder) {
        this.codeRepositoryName = builder.codeRepositoryName;
        this.codeRepositoryArn = builder.codeRepositoryArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.gitConfig = builder.gitConfig;
    }

    public String codeRepositoryName() {
        return this.codeRepositoryName;
    }

    public String codeRepositoryArn() {
        return this.codeRepositoryArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public GitConfig gitConfig() {
        return this.gitConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositorySummary)) {
            return false;
        }
        CodeRepositorySummary other = (CodeRepositorySummary)obj;
        return Objects.equals(this.codeRepositoryName(), other.codeRepositoryName()) && Objects.equals(this.codeRepositoryArn(), other.codeRepositoryArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.gitConfig(), other.gitConfig());
    }

    public String toString() {
        return ToString.builder((String)"CodeRepositorySummary").add("CodeRepositoryName", (Object)this.codeRepositoryName()).add("CodeRepositoryArn", (Object)this.codeRepositoryArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("GitConfig", (Object)this.gitConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.codeRepositoryName()));
            }
            case "CodeRepositoryArn": {
                return Optional.ofNullable(clazz.cast(this.codeRepositoryArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "GitConfig": {
                return Optional.ofNullable(clazz.cast(this.gitConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositorySummary, T> g) {
        return obj -> g.apply((CodeRepositorySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codeRepositoryName;
        private String codeRepositoryArn;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private GitConfig gitConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositorySummary model) {
            this.codeRepositoryName(model.codeRepositoryName);
            this.codeRepositoryArn(model.codeRepositoryArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.gitConfig(model.gitConfig);
        }

        public final String getCodeRepositoryName() {
            return this.codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        public final String getCodeRepositoryArn() {
            return this.codeRepositoryArn;
        }

        @Override
        public final Builder codeRepositoryArn(String codeRepositoryArn) {
            this.codeRepositoryArn = codeRepositoryArn;
            return this;
        }

        public final void setCodeRepositoryArn(String codeRepositoryArn) {
            this.codeRepositoryArn = codeRepositoryArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final GitConfig.Builder getGitConfig() {
            return this.gitConfig != null ? this.gitConfig.toBuilder() : null;
        }

        @Override
        public final Builder gitConfig(GitConfig gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        public final void setGitConfig(GitConfig.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        public CodeRepositorySummary build() {
            return new CodeRepositorySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositorySummary> {
        public Builder codeRepositoryName(String var1);

        public Builder codeRepositoryArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder gitConfig(GitConfig var1);

        default public Builder gitConfig(Consumer<GitConfig.Builder> gitConfig) {
            return this.gitConfig((GitConfig)((GitConfig.Builder)GitConfig.builder().applyMutation(gitConfig)).build());
        }
    }
}

