/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageStatusItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageStatusItem> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageStatusItem.getter(ModelPackageStatusItem::name)).setter(ModelPackageStatusItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageStatusItem.getter(ModelPackageStatusItem::statusAsString)).setter(ModelPackageStatusItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelPackageStatusItem.getter(ModelPackageStatusItem::failureReason)).setter(ModelPackageStatusItem.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String failureReason;

    private ModelPackageStatusItem(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    public String name() {
        return this.name;
    }

    public DetailedModelPackageStatus status() {
        return DetailedModelPackageStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageStatusItem)) {
            return false;
        }
        ModelPackageStatusItem other = (ModelPackageStatusItem)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"ModelPackageStatusItem").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageStatusItem, T> g) {
        return obj -> g.apply((ModelPackageStatusItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageStatusItem model) {
            this.name(model.name);
            this.status(model.status);
            this.failureReason(model.failureReason);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetailedModelPackageStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public ModelPackageStatusItem build() {
            return new ModelPackageStatusItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageStatusItem> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(DetailedModelPackageStatus var1);

        public Builder failureReason(String var1);
    }
}

