/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContainerArgumentsCopier;
import software.amazon.awssdk.services.sagemaker.model.ContainerEntrypointCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSpecification.getter(AppSpecification::imageUri)).setter(AppSpecification.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AppSpecification.getter(AppSpecification::containerEntrypoint)).setter(AppSpecification.setter(Builder::containerEntrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AppSpecification.getter(AppSpecification::containerArguments)).setter(AppSpecification.setter(Builder::containerArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ARGUMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final List<String> containerEntrypoint;
    private final List<String> containerArguments;

    private AppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerArguments = builder.containerArguments;
    }

    public String imageUri() {
        return this.imageUri;
    }

    public List<String> containerEntrypoint() {
        return this.containerEntrypoint;
    }

    public List<String> containerArguments() {
        return this.containerArguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerEntrypoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerArguments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSpecification)) {
            return false;
        }
        AppSpecification other = (AppSpecification)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.containerEntrypoint(), other.containerEntrypoint()) && Objects.equals(this.containerArguments(), other.containerArguments());
    }

    public String toString() {
        return ToString.builder((String)"AppSpecification").add("ImageUri", (Object)this.imageUri()).add("ContainerEntrypoint", this.containerEntrypoint()).add("ContainerArguments", this.containerArguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ContainerEntrypoint": {
                return Optional.ofNullable(clazz.cast(this.containerEntrypoint()));
            }
            case "ContainerArguments": {
                return Optional.ofNullable(clazz.cast(this.containerArguments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSpecification, T> g) {
        return obj -> g.apply((AppSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppSpecification model) {
            this.imageUri(model.imageUri);
            this.containerEntrypoint(model.containerEntrypoint);
            this.containerArguments(model.containerArguments);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        public final Collection<String> getContainerEntrypoint() {
            return this.containerEntrypoint;
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String ... containerEntrypoint) {
            this.containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
        }

        public final Collection<String> getContainerArguments() {
            return this.containerArguments;
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String ... containerArguments) {
            this.containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = ContainerArgumentsCopier.copy(containerArguments);
        }

        public AppSpecification build() {
            return new AppSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSpecification> {
        public Builder imageUri(String var1);

        public Builder containerEntrypoint(Collection<String> var1);

        public Builder containerEntrypoint(String ... var1);

        public Builder containerArguments(Collection<String> var1);

        public Builder containerArguments(String ... var1);
    }
}

